#include <stdlib.h>
#include <stdio.h>
//#include <sys/socket.h>
//#include <netinet/in.h>
#include <string.h>

#include "socket.h"

int listen_port(unsigned port)
{
  int retval = socket(AF_INET, SOCK_DGRAM, 0);
  struct sockaddr_in sock_struct;

  if(!retval == -1)
  {
    puts("Could not create a socket");
    return -1;
  }
  puts("Socket created.");

  sock_struct.sin_port = (port << 8) | (port >> 8);
  sock_struct.sin_addr.s_addr = INADDR_ANY;
  sock_struct.sin_family = AF_INET;

  puts("Binding the socket to local port...");
  if(bind(retval, &sock_struct, sizeof(struct sockaddr_in)) == -1)
  {
    puts("Bind failed");
    return -1;
  }
  printf("Bound to port %u\n", port);

  return retval;
}

void listen_loop(int socket)
{
  struct sockaddr_in sock_struct;
  char buff[100];
  unsigned struct_len = sizeof(struct sockaddr_in);

  puts("Listening...");
  while(1)
  {
    memset(buff, 0, sizeof(buff));
    if(recvfrom(socket, buff, sizeof(buff), 0, &sock_struct, &struct_len) == -1)
    {
      puts("recvfrom() failed");
      return;
    }
    puts(buff);
    memset(buff, 0, sizeof(buff));
    gets(buff);
    if(sendto(socket, buff, strlen(buff), 0, &sock_struct, sizeof(struct sockaddr_in)) == -1)
    {
      puts("sendto() failed");
      return;
    }
  }
}

int main(int argc, char *argv[])
{
  unsigned port;
  int s;

  if(argc < 2)
  {
    puts("No port");
    return 1;
  }

  port = atoi(argv[1]);

  s = listen_port(port);

  if(s != -1)
    listen_loop(s);

  return 0;
}
