.8086

.MODEL small


PUBLIC copymem_
PUBLIC lenstr_
PUBLIC setmem_
PUBLIC chrmem_

_TEXT               SEGMENT BYTE PUBLIC USE16 'CODE'
                ASSUME CS:_TEXT                               

; dx:si = source, es:di = destination, cx = count
copymem_ proc near
  push ds
  mov ds, dx
  push di
  cld

IFDEF __386__
.386
  ror ecx, 2
  and ch, 0x3F
  rep movsd
  rol ecx, 2
  rep movsb
ELSE
  shr cx, 1
  rep movsw
  adc cx, cx
  rep movsb
ENDIF


  pop di
  pop ds
  ret  
copymem_ endp

; es:di = destination, al = set byte, cx = count
setmem_ proc near
  push di
  cld

IFDEF __386__
  .386
  mov ah, al
  push ax
  shl eax, 16
  pop ax
  ror ecx, 2
  and ch, 0x3F
  rep stosd
  rol ecx, 2
  rep stosb
ELSE
  mov ah, al
  shr cx, 1
  rep stosw
  adc cx, cx
  rep stosb
ENDIF


  pop di
  ret
setmem_ endp

; es:di = pointer to string
lenstr_ proc near
;  pushf
  cld
  push cx

; find null byte  
  mov cx, 0xFFFF
  sub cx, di
  xor al, al
  push di
  repne scasb

  mov ax, di
  dec ax
  pop di
; string length == ax - di
  sub ax, di

  pop cx
;  popf
  ret
lenstr_ endp

; al = byte, es:di = buffer, cx = count
chrmem_ proc near
  cld
  repne scasb
  jz chrmem_end
  xor di, di
  mov es, di
  ret
  chrmem_end:
  dec di
  ret
chrmem_ endp

_TEXT ENDS

END


