unsigned char send_pkt(unsigned char __far *buff, unsigned len);
#pragma aux send_pkt = \
  "push ds" \
  "mov ds, dx" \
  "mov ah, 4" \
  "inc cs:transmission_flag" \
  "push cx" \
  "int 0x60" \
  "pop cx" \
  "jnc end" \
  "mov al, dh" \
  "inc cs:tx_error_count" \
  "jmp end2" \
  "end:" \
  "xor al, al" \
  "inc cs:tx_packets" \
  "add word ptr cs:tx_bytes, cx" \
  "adc word ptr cs:tx_bytes+2, 0" \
  "end2:" \
  "dec cs:transmission_flag" \
  "pop ds" \
  parm [dx si] [cx] value [al];

unsigned char send_pkt_as(unsigned char __far *buff, unsigned len);
#pragma aux send_pkt_as = \
  "push dx" \
  "mov ah, 12" \
  "inc cs:transmission_flag" \
  "push cx" \
  "int 0x60" \
  "pop cx" \
  "jnc end" \
  "mov al, dh" \
  "dec cs:transmission_flag" \
  "jmp end2" \
  "end:" \
  "xor al, al" \
  "inc cs:tx_packets" \
  "add word ptr cs:tx_bytes, cx" \
  "adc word ptr cs:tx_bytes+2, 0" \
  "end2:" \
  "pop dx" \
  parm [es di] [cx] value [al];

static unsigned char send_pkt_nonblock(char __far *buff, unsigned length)
{
  unsigned char __far *strct;
  unsigned n;
  unsigned char __far *ptr;
  #define transmit_buffer *(char __far* __far*)&strct[0]
  #define transmit_length *(unsigned __far*)&strct[4]
  #define transmit_flags strct[6]
  #define transmit_upcall *(void __far* __far*)&strct[8]

  if(outpktbuff_inuse == 0xFF)
  {
    for(n=driver.max_sends;n--;)
    {
      ptr = out_pkt_buffs[n];
      strct = &ptr[OUT_PACKET_SIZE];
      if(transmit_flags & 1)
      {
//        _fmemcpy(out_pkt_buffs[n], buff, OUT_PACKET_SIZE);
        _fmemcpy(ptr, buff, length);
        goto transmit;
      }
    }
    if(n == -1) return -1;
  }
  else
  {
    n = outpktbuff_inuse;
    ptr = out_pkt_buffs[n];
//    _fmemcpy(ptr, buff, length);
    strct = &ptr[OUT_PACKET_SIZE];
  }

//  if(buff != ptr)
//    _fmemcpy(ptr, buff, OUT_PACKET_SIZE);
  transmit:
  transmit_buffer = ptr;
  transmit_length = length;
  transmit_flags = 2;
  transmit_upcall = (void __far*)upcall;

  return send_pkt_as(strct, length);
}

static int transmit_not_ready(void)
{
  return (transmission_flag == driver.max_sends);
}

int transmit_block(void);
#pragma aux transmit_block value [ax];
int transmit_block(void)
{
  if(!driver.hi_perf) return 0;
  return transmit_not_ready();
}

static unsigned char __far *get_free_async_buff(void)
{
  unsigned n;
  unsigned char __far *strct;

  if(driver.hi_perf)
  {
    while(transmit_not_ready());

    for(n=driver.max_sends;n--;)
    {
      strct = &out_pkt_buffs[n][OUT_PACKET_SIZE];
      if(transmit_flags & 1)
        goto end;
//        return out_pkt_buffs[n];
    }
  }
  else n = 0;
  end:
  outpktbuff_inuse = n;
  return out_pkt_buffs[n];
}

static struct incoming_packet parse_packet(struct raw_packet );

struct loopback __based(__segname("_CODE")) loopback;

static int loopback_pkt(unsigned char __far *buff, unsigned len)
{
  int rc;

  if(loopback.has_data) rc = 1;
  else
  {
    loopback.packet.length = len;  
    _fmemcpy(&loopback.packet.data[6], &buff[6], len-6);
    _fmemcpy(loopback.packet.data, my_mac, 6);
    loopback.has_data = 1;
    loopback.processing = 0;
    rc = 0;
  }
  outpktbuff_inuse = 0xFF;
  return rc;
}

extern unsigned char __based(__segname("_CODE")) bios_dmaio_in_progress;

static unsigned char send_raw_packet(unsigned char __far *buff, unsigned len)
{
  unsigned char retval;
  if(bios_dmaio_in_progress) retval = 1;
  else
  {
    #ifndef DISABLE_HIPERF
    if(driver.hi_perf)
      retval = send_pkt_nonblock(buff, len);
    else
    #endif
      retval = send_pkt(buff, len);
  }

  outpktbuff_inuse = 0xFF;

  return retval;
}

static unsigned char send_ip_packet(unsigned char __far *buff, unsigned len)
{
  unsigned char __far *ip_header = &buff[14];
  if(ip_header[16] != 127)
  {
    if(len < 60)
    {
      // assume the buffer is OUT_PACKET_SIZE long
      _fmemset(&buff[len], 0, 60-len);
      len = 60;
    }
    return send_raw_packet(buff, len);
  }
  else
  {
    ip_header[12] = 127; // to indicate that this packet is from localhost
    return loopback_pkt(buff, len);
  }
}

static unsigned char send_ip6_packet(unsigned char __far *buff, unsigned len)
{
  unsigned char __far *ip_header = &buff[14];
  unsigned n;
  if(!is_localhost6(&ip_header[24]))
  {
    if(len < 60)
    {
      _fmemset(&buff[len], 0, 60-len);
      len = 60;
    }
    return send_raw_packet(buff, len);
  }
  else
  {
    _fmemcpy(&ip_header[8], &ip_header[24], 16);
    return loopback_pkt(buff, len);
  }
}

unsigned get_my_mac(unsigned char __far *buff);
#pragma aux get_my_mac = \
  "mov ah, 6" \
  "mov bx, word ptr cs:driver" \
  "mov cx, 6" \
  "int 0x60" \
  "jnc end" \
  "mov ah, dh" \
  "jmp end2" \
  "end:" \
  "mov ah, 0" \
  "end2:" \
  "mov ax, cx" \
  parm [es di] value [ax] modify [bx cx dx];

void __far *allocate_input_buffer(unsigned paragraphs);
#pragma aux allocate_input_buffer = \
  "push bx" \
  "mov ah, 0x48" \
  "int 0x21" \
  "jnc success" \
  "xor ax, ax" \
  "xor dx, dx" \
  "jmp fail" \
  "success:" \
  "mov dx, ax" \
  "dec dx" \
  "mov ax, 0x10" \
  "fail:" \
  "pop bx" \
  value [dx ax] parm [bx];

static int packet_ready(void)
{
  unsigned n = RAW_PACKET_COUNT;
//  disable(); // shouldn't be needed...
  while(n--)
    if(raw_packet[n].data)
      break;
//  enable();
  return n;
}

void __far *get_parameters(void);
#pragma aux get_parameters = \
  "mov ah, 10" \
  "int 0x60" \
  "jnc end" \
  "xor di, di" \
  "mov es, di" \
  "end:" \
  value [es di];



static void release_type(void)
{
  unsigned handle = driver.handle;

  __asm
  {
    mov ah, 7
    mov bx, handle
    int 0x60
    mov ah, 3
    mov bx, handle
    int 0x60    
  }
}
