#include <stdlib.h>
#include <stdio.h>
#include <i86.h>
#include <dos.h>
#include <conio.h>
//#include <string.h>

void debug_int(void);
#pragma aux debug_int = \
  "int 3";

extern void *call_dos;

#include "time.c"
#include "pragmas.c"
#include "errdef.c"

unsigned char __based(__segname("_CODE")) tcp_int;

#include "defines.c"
#include "structs.c"
#include "ringcopy.c"
#include "endian.c"
#include "globals.c"
#include "tsr.c"
#include "receiver.c"
#include "packet.c"
#include "ipv4.c"
#include "ipv6.c"
#include "icmp.c"
#include "nd6.c"
#include "icmp6.c"
#include "arp.c"
#include "send.c"
#include "udpipv4.c"
#include "udpipv6.c"
#include "congctrl.c"
#include "tcp.c"
#include "tcp6.c"
#include "rawsock.c"
#include "ping.c"
#include "dns.c"
#include "pcktpars.c"
#include "dhcp.c"
#include "dhcp6.c"
#include "sockets.c"
#include "easyuse.c"
#include "errcodes.c"
#include "dfragmem.c"

void __far * __based (__segname("_CODE")) prev_int_61;

void debug(char chr);
#pragma aux debug = \
  "mov ah, 0x0E" \
  "mov bh, 0" \
  "mov bl, 0x7" \
  "int 0x10" \
  parm [al] modify [ax bx];

char outofmemory[] = "Out of memory.";

void end_tcp_stack(void)
{
  release_type();
  set_vector(tcp_int, prev_int_61);
  set_vector(0x1C, old_timer_handler);
  set_vector(0x2E, old_oom_int);
}

#include "setup.c"
#include "init.c"

void init_tcp_stack(void)
{
  unsigned w;  
  
  if(!_dos_getvect(0x60))
  {
    puts("No packet driver at 0x60");
    error:
    set_vector(tcp_int, prev_int_61);
    exit(1);
  }

  puts("Loading settings...");
  if(load_ip_setup())
    goto error;
  
  if(get_driver_info())
    goto nomemory;
  printf("Packet driver %Ws found\n", (char __far*)driver.name);
  printf("High performance functionality is ");
  if(!(driver.hi_perf))
    printf("not ");
  puts("supported.");

  if(!(driver.extended))
    puts("Your packet driver does not support extended functionality - it may \
be impossible to receive IPv6 multicast frames!");
  else puts("Extended functionality is supported.");

  int21_handler = _dos_getvect(0x21);

  input_buffer = allocate_input_buffer(RAW_PACKET_BUFFER);

  if(!input_buffer)
  {
    nomemory:
    puts(outofmemory);
    exit(1);
  }

  _fmemset(input_buffer, 0, RAW_PACKET_BUFFER<<4);
  _fmemset((void __far*)raw_packet, 0, RAW_PACKET_COUNT*sizeof(struct raw_packet));
  printf("Allocated input buffer at %Wp\n", input_buffer);

  puts("Allocating TCP...");
  sockets = tcpmalloc(MAX_SOCKETS * sizeof(struct transmission_control_block __far*));
  if(!FP_SEG(sockets)) goto nomemory;
  printf("Allocated TCP at %Wp\n", sockets);    
  _fmemset(sockets, 0, MAX_SOCKETS * sizeof(struct transmission_control_block __far*));

  puts("Allocating loopback buffer...");
  loopback.packet.data = tcpmalloc(OUT_PACKET_SIZE);
  if(!FP_SEG(loopback.packet.data)) goto nomemory;

  puts("Allocating buffers for outgoing packets...");
  outgoing_packets = tcpmalloc(OUT_PACKETS*sizeof(struct out_packet));
  if(!FP_SEG(outgoing_packets)) goto nomemory;
  for(w=0;w<OUT_PACKETS;w++)
    outgoing_packets[w].socket = -1;

  open_ports = tcpmalloc(MAX_OPEN_PORTS * sizeof(struct open_port_control_block __far*));
  if(!FP_SEG(open_ports)) goto nomemory;
  printf("Allocated table of open ports at %Wp\n", open_ports);
  _fmemset(open_ports, 0, MAX_OPEN_PORTS * sizeof(struct open_port_control_block __far*));

  dns_cache = tcpmalloc(DNS_CACHE_SIZE* sizeof(struct dns_query));
  if(!FP_SEG(dns_cache)) goto nomemory;
  printf("Allocated DNS cache at %Wp\n", dns_cache);    
  _fmemset(dns_cache, 0, DNS_CACHE_SIZE * sizeof(struct dns_query));  

  arp_cache = tcpmalloc(ARP_CACHE_SIZE * sizeof(struct mac_cache));
  if(!FP_SEG(arp_cache)) goto nomemory;
  printf("Allocated ARP cache at %Wp\n", arp_cache);
  _fmemset(arp_cache, 0, ARP_CACHE_SIZE * sizeof(struct mac_cache));

  puts("Setting receiver...");
  set_receiver();

  for(w=6;w--;)
    if(my_mac[w])
    {
      w = 6;
      goto mac_from_setupini;
    }
  w = get_my_mac((void __far*)my_mac);
  if(w & 0xFF00)
    puts("Error getting local address");
  else
  {
    mac_from_setupini:
    printf("Local address is %u bytes long: ", w);
    printf("%.2X %.2X %.2X %.2X %.2X %.2X\n", my_mac[0], my_mac[1], my_mac[2], my_mac[3], my_mac[4], my_mac[5]);
  }

  seed_dosrand();
}

void unload_tcp(void);
#pragma aux unload_tcp = \
  "mov ax, 0xFF" \
  "int 0x61" \
  modify [ax es];

#pragma aux main aborts;
void main(int argc, char **argv)
{
  unsigned long t;
  unsigned char r;

  tcp_int = 0x61;

  prev_int_61 = _dos_getvect(tcp_int);

  if(argc == 2 && !strcmp(argv[1], "/UNLOAD"))
  {
    if(!prev_int_61)
    {
      puts("TCP/IP stack not loaded!");
    }
    else
    {
      puts("Unloading TCP/IP stack.");
      unload_tcp();
    }
    exit(0);
  }

  puts("Loading TCP/IP stack v. 0.142...");

  if(prev_int_61)
  {
    puts("Interrupt already in use");
    exit(1);
  }

  save_psp();

  _fmemcpy(gateway_mac, broadcast_mac, 6);
  _fmemcpy(gateway6_mac, broadcast_mac, 6);

  init_tcp_stack();

  set_vector(tcp_int, (void __far*)tcp_service);
  old_timer_handler = _dos_getvect(0x1C);
  set_vector(0x1C, (void __far*)timer_int);
  old_oom_int = _dos_getvect(0x2E);
  set_vector(0x2E, (void __far*)oom_int);

  printf("Installed to interrupt %u...\n", tcp_int);

  if(lease.status == 3)
  {
    puts("Using DHCP to get IP setup...");
    dhcpdiscover();
    do
    {
      service_packets();
      if(ttime(0) > lease.request_time + DHCP_TIMEOUT)
      {
        if(lease.status)
        {
          puts("DHCP timeout expired, exiting.");
          end_tcp_stack();
          exit(1);
        }
        else if(lease6.status)
        {
          puts("Could not get an IPv6 address - using link-local address...");
          lease6.status = -1;
          _fmemcpy(&ipv6_global_addr, &ipv6_local_addr, sizeof(struct ipv6_addr));
          break;
        }
      }
    }
    while(lease.status || lease6.status);
    puts("OK!");
    printf("My IPv4 address: %u.%u.%u.%u\n", ipv4_my_addr.p1, ipv4_my_addr.p2, ipv4_my_addr.p3, ipv4_my_addr.p4);
    printf("Broadcast IP: %u.%u.%u.%u\n", ipv4_broadcast.p1, ipv4_broadcast.p2, ipv4_broadcast.p3, ipv4_broadcast.p4);
    printf("Netmask: %u.%u.%u.%u\n", ipv4_netmask.p1, ipv4_netmask.p2, ipv4_netmask.p3, ipv4_netmask.p4);
    printf("Gateway: %u.%u.%u.%u\n", ipv4_gateway.p1, ipv4_gateway.p2, ipv4_gateway.p3, ipv4_gateway.p4);
    printf("DNS server: %u.%u.%u.%u\n", ipv4_dns.p1, ipv4_dns.p2, ipv4_dns.p3, ipv4_dns.p4);

    printf("My IPv6 link-local address: %x:%x:%x:%x:%x:%x:%x:%x\n",
            switch_endianness_s(ipv6_local_addr.p1),
            switch_endianness_s(ipv6_local_addr.p2),
            switch_endianness_s(ipv6_local_addr.p3),
            switch_endianness_s(ipv6_local_addr.p4),
            switch_endianness_s(ipv6_local_addr.p5), 
            switch_endianness_s(ipv6_local_addr.p6), 
            switch_endianness_s(ipv6_local_addr.p7), 
            switch_endianness_s(ipv6_local_addr.p8));

    printf("My IPv6 globally routable address: %x:%x:%x:%x:%x:%x:%x:%x\n",
            switch_endianness_s(ipv6_global_addr.p1),
            switch_endianness_s(ipv6_global_addr.p2),
            switch_endianness_s(ipv6_global_addr.p3),
            switch_endianness_s(ipv6_global_addr.p4),
            switch_endianness_s(ipv6_global_addr.p5), 
            switch_endianness_s(ipv6_global_addr.p6), 
            switch_endianness_s(ipv6_global_addr.p7), 
            switch_endianness_s(ipv6_global_addr.p8));

    t = ttime(0);
    printf("IPv4 lease time: %li\n", lease.lease_end_time - t);
    printf("IPv6 lease time: %li\n", lease6.lease_end_time - t);
  }

//  request_ping(ipv4_gateway);

  puts("Resolving routes...");
  t = ttime(0);
  r = 10;
  while(r && (!_fmemcmp(gateway_mac, broadcast_mac, 6) || 
        !_fmemcmp(gateway6_mac, broadcast_mac, 6)))
  
  {
    if(t != ttime(0))
    {
      if(!_fmemcmp(gateway_mac, broadcast_mac, 6))
        send_arp_request_ipv4(ipv4_gateway);
      if(!_fmemcmp(gateway6_mac, broadcast_mac, 6))
        send_router_sol();
//        send_nd_sol(&ipv6_all_routers, &ipv6_all_routers, 133);
      t = ttime(0);
      r--;
    }

    service_packets();
  }

  if(!r)
  {
    puts("WARNING: No reply from the gateway, using default MAC!");
  }

  printf("IPv4 gateway MAC: %.2X:%.2X:%.2X:%.2X:%.2X:%.2X\n", gateway_mac[0], 
    gateway_mac[1], gateway_mac[2], gateway_mac[3], gateway_mac[4], gateway_mac[5]);
  printf("IPv6 gateway MAC: %.2X:%.2X:%.2X:%.2X:%.2X:%.2X\n", gateway6_mac[0], 
    gateway6_mac[1], gateway6_mac[2], gateway6_mac[3], gateway6_mac[4], gateway6_mac[5]);
  
  tsr();
}

unsigned code_segment(void);
#pragma aux code_segment = \
  "mov ax, cs" \
  value [ax];
#define CODE_SEGMENT code_segment()

#define STACK_SIZE 2048
#pragma aux tsr aborts;
void tsr(void)
{
// TODO:
  data_seg = stack_seg = CODE_SEGMENT + ((FP_OFF(load_ip_setup) + 0xF) >> 4);
//  stack_ptr = STACK_SIZE;
  printf("Going resident...\n", tcp_int);
  go_tsr(0, ((FP_OFF(load_ip_setup) + 0xF) >> 4) + 0x10 + (STACK_SIZE>>4));
}
