static int address_in_same_ipv4_subnet(struct ipv4_addr address)
{
  if((address.p1 & ipv4_netmask.p1) == (ipv4_my_addr.p1 & ipv4_netmask.p1)
  && (address.p2 & ipv4_netmask.p2) == (ipv4_my_addr.p2 & ipv4_netmask.p2)
  && (address.p3 & ipv4_netmask.p3) == (ipv4_my_addr.p3 & ipv4_netmask.p3)
  && (address.p4 & ipv4_netmask.p4) == (ipv4_my_addr.p4 & ipv4_netmask.p4))
    return 1;
  return 0;
}

/* initializes a default ipv4 header struct */
static void init_ipv4_header_struct(struct ipv4_header *header, unsigned char protocol, struct ipv4_addr remote_addr)
{
  header->type_of_service = 0;
  header->identification = random();
  header->flags.dont_fragment = 0;
  header->flags.more_fragments = 0;
  header->fragment_offset = 0;
  header->time_to_live = 0xFF;
  header->protocol = protocol;

  header->src_address = ipv4_my_addr;
  header->dst_address = remote_addr;
}

/*
  Builds a valid ipv4 header.
  Argument 1: pointer to a 64 bytes long array where the header is stored
  Argument 2: poinster to a struct containing header information
  Returns the length of the header.
*/
static int build_ipv4_header(unsigned char __far *header, struct ipv4_header *headstruct)
{
//  unsigned short header_bytes = 20;
#define header_bytes 20
  unsigned short __far *shortptr = (unsigned short __far*)header;

  header[1] = headstruct->type_of_service;

  shortptr[2>>1] = 0; // length
  shortptr[4>>1] = switch_endianness_s(headstruct->identification);
  shortptr[6>>1] = switch_endianness_s(headstruct->fragment_offset);
  if(headstruct->flags.dont_fragment)
    header[6] |= 0x40;
  if(headstruct->flags.more_fragments)
    header[6] |= 0x20;

  header[8] = headstruct->time_to_live;
  header[9] = headstruct->protocol;

  shortptr[10>>1] = 0; // checksum

/*  header[12] = headstruct->src_address.p1;
  header[13] = headstruct->src_address.p2;
  header[14] = headstruct->src_address.p3;
  header[15] = headstruct->src_address.p4;*/
  _fmemcpy(&header[12], &headstruct->src_address, 4);

/*  header[16] = headstruct->dst_address.p1;
  header[17] = headstruct->dst_address.p2;
  header[18] = headstruct->dst_address.p3;
  header[19] = headstruct->dst_address.p4;*/
  _fmemcpy(&header[16], &headstruct->dst_address, 4);


  *(unsigned short __far*)&header[10] = 0;

  header[0] = 0x40 | (header_bytes >> 2);

  return header_bytes;
#undef header_bytes
}

static void ipv4_inject_lengthinfo(unsigned char __far *packet, unsigned length)
{
  unsigned short __far *dst = (unsigned short __far *)&packet[2];
  *dst = switch_endianness_s(length);
}

static unsigned ipv4_header_checksum(unsigned char __far *header, unsigned header_length)
{
  register unsigned checksum = 0;
  register unsigned addition;
  unsigned short __far *sptr = (unsigned short __far*)header;

  header_length>>=1;

  while(header_length--)
  {
    addition = sptr[header_length];
    checksum += addition;
    if(checksum < addition)
      if(!++checksum)
        checksum++;
  }

  return ~checksum;
}

static void ipv4_inject_header_checksum(unsigned char __far *packet, unsigned header_length)
{
  unsigned short __far *dest = (unsigned short __far*)&packet[10];

//  *dest = switch_endianness_s(ipv4_header_checksum(packet, header_length));
  *dest = ipv4_header_checksum(packet, header_length);
}

static unsigned char __based (__segname("_CODE")) pseudoheader[40];

static unsigned short __far *ipv4_pseudoheader(struct ipv4_addr src_addr, struct ipv4_addr dst_addr, unsigned len, unsigned char protocol)
{
//  static unsigned char __based (__segname("_CODE")) retval[12];
  unsigned char __far *retval = pseudoheader;
  unsigned short __far *lenptr = (unsigned short __far*)&retval[10];

  _fmemcpy(retval, &src_addr, 4);
  _fmemcpy(&retval[4], &dst_addr, 4);

  retval[8] = 0;
  retval[9] = protocol;

  *lenptr = switch_endianness_s(len);

  return (unsigned short __far*)retval;
}

