static void seed_dosrand(void)
{
  DOSRAND_SEED = ttime(0);
  DOSRAND_SEED += *(unsigned __far*)&my_mac[2];
  DOSRAND_SEED += *(unsigned __far*)&my_mac[4];
}

static int get_driver_info(void)
{
//  union REGS regs;
//  struct SREGS sregs;
  unsigned version;
  unsigned type;
  char class;
  char number;
  char functionality;
  char *driver_name;
  unsigned name_segment;
  unsigned char __far *ptr;
  unsigned n;

/*  regs.h.ah = 1;
  regs.h.al = 255;
  regs.w.bx = 0;*/

//  int86x(0x60, &regs, &regs, &sregs);
  __asm
  {
    push ds
    mov ah, 1
    mov al, 255
    mov bx, 0
    int 0x60
    mov version, bx
    mov type, dx
    mov class, ch
    mov number, cl
    mov functionality, al
    mov driver_name, si
    mov name_segment, ds
    pop ds
  }

/*  driver.version = regs.w.bx;
  driver.type = regs.w.dx;
  driver.class = regs.h.ch;
  driver.number = regs.h.cl;
  driver.functionality = regs.h.al;*/

//  _fstrncpy(driver.name, MK_FP(sregs.ds, regs.w.si), 64);

  driver.version = version;
  driver.type = type;
  driver.class = class;
  driver.number = number;
  driver.functionality = functionality;
  _fstrncpy(driver.name, MK_FP(name_segment, driver_name), 64);

  if(driver.functionality != 0xFF)
  {
    if(driver.functionality & 0x02)
      driver.extended = 1;
    if(driver.functionality & 0x04)
    {
      ptr = get_parameters();
      if(ptr)
      {
        driver.spec_major = ptr[0];
        driver.spec_minor = ptr[1];
        printf("Driver's specification version is %u.%.2u\n", driver.spec_major, driver.spec_minor);
        if((driver.spec_major == 1 && driver.spec_minor >= 10) || driver.spec_major > 1)
        {
          driver.hi_perf = 1;
          driver.max_sends = 1 + *(unsigned __far*)&ptr[10];
  
          printf("Max async sends: %u\n", driver.max_sends);
  
          if(driver.max_sends < MAX_HIPERF_OUTPACKET_BUFFERS)
            n = driver.max_sends;
          else
          {
            n = MAX_HIPERF_OUTPACKET_BUFFERS;
            driver.max_sends = n;
          }
          while(n--)
          {
            out_pkt_buffs[n] = tcpmalloc(OUT_PACKET_SIZE+24);
            if(!FP_SEG(out_pkt_buffs[n])) // disable hi-performance functionality
            {                     // when out of memory
              do
                ffree(out_pkt_buffs[n]);
              while(++n < MAX_HIPERF_OUTPACKET_BUFFERS);
              driver.hi_perf = 0;
              goto low_perf;
            }
            out_pkt_buffs[n][OUT_PACKET_SIZE+6] = 1;
          }
          return 0;
        }
      }
    }
  }

  low_perf:
  driver.max_sends = 1;
  out_pkt_buffs[0] = tcpmalloc(OUT_PACKET_SIZE);
  if(!FP_SEG(out_pkt_buffs[0]))
    return 1;
  return 0;
}


//void __far * __far receiver(unsigned phase, unsigned length);

static void set_receiver(void)
{
  union REGS regs;
  struct SREGS sregs;
  unsigned char class = driver.class;
  unsigned type = driver.type;
  unsigned char number = driver.number;
//  unsigned packet_seg = FP_SEG(packet_type); // not needed

  static char __based (__segname("_CODE")) packet_type[2] = { 0x08, 0x00 }; // IP packets  
  unsigned packet_off = FP_OFF(packet_type);

  unsigned receiver_seg = FP_SEG(receiver_wrapper);
  unsigned receiver_off = FP_OFF(receiver_wrapper);
  unsigned handle;
  unsigned char error = 0;

  __asm
  {
    push ds
    mov bx, type
    mov dl, number
    mov cx, 0
    mov ax, cs
    mov ds, ax
    mov es, receiver_seg
    mov al, class
    mov ah, 2
    mov di, receiver_off
    int 0x60
    jnc noerror
    mov error, dh
    noerror:
    mov handle, ax
    pop ds
  }

  if(error)
  {
    puts("Could not match all packets, trying with ARP disabled...");
    error = 0;

    __asm
    {
      push ds
      mov bx, type
      mov dl, number
      mov cx, 2
      mov si, offset packet_type
      mov ax, cs
      mov ds, ax
      mov es, receiver_seg
      mov al, class
      mov ah, 2
      mov di, receiver_off
      int 0x60
      jnc noerror
      mov error, dh
      noerror:
      mov handle, ax
      pop ds
    }
  }


  if(error)
  {
    printf("Error %u\n", (unsigned short)error);
    exit(0);
  }

  if(driver.extended) // extended functionality supported
  {
    __asm
    {
      mov ah, 20
      mov bx, handle
      mov cx, 6 // receive all packets
      int 0x60
      jnc noerror
      mov error, dh
      noerror:
    }
  }

  if(error)
  {
    printf("Could not change receive mode to 6 - error %u\n", error);
  }

  driver.handle = handle;
}

static int send_dhcp6_request(void);

static int dhcpdiscover(void)
{
  int rc;

  lease.id = random32();
  lease.request_time = ttime(0);
  lease.status = 1; // waiting for DHCPOFFER
  lease.lease_end_time = -1;
  _fmemset((void __far*)&ipv4_my_addr, 0, sizeof(struct ipv4_addr));

  lease6.transaction_id = random32() & 0xFFFFFF00;
//  lease6.status = 6;
  lease6.start_time = lease6.request_time = lease.request_time;
  lease6.lease_end_time = -1;
  lease6.iaid = random32();

  rc = send_dhcp_request();
  if(!rc)
    return send_dhcp6_request();
  else return rc;
}
