static unsigned long clock_tick_count(void)
{
  return (((unsigned long)clock_ticks)<<16) | pit_counter();
}

static unsigned socket_packet_in_buffers(unsigned socket, unsigned long ack_num)
{
  unsigned n = OUT_PACKETS;

  while(n--)
    if(outgoing_packets[n].socket == socket
       && outgoing_packets[n].ack_num == ack_num) break;
  return n;
}

static unsigned socket_packets_in_buffers(unsigned socket)
{
  unsigned retval = 0;
  unsigned n = OUT_PACKETS;

  while(n--)
    if(outgoing_packets[n].socket == socket)
      retval++;
  return retval;
}

static int too_much_ploss(unsigned socket)
{
  return (sockets[socket]->ploss > OUT_PACKETS-socket_packets_in_buffers(socket));
}

static void add_outpacket(unsigned socket, unsigned char __far *packet, unsigned len, unsigned payload_size)
{
  unsigned n = OUT_PACKETS;
  unsigned long ack_num = sockets[socket]->send.count + sockets[socket]->send.iss
                     + sockets[socket]->send.ack_waiting;

  if(socket_packet_in_buffers(socket, ack_num) != -1) return;
  if(too_much_ploss(socket)) return;
  if(!((sockets[socket]->out_buff_read_offset + sockets[socket]->send.ack_waiting)
     - sockets[socket]->out_buff_write_offset)
     && sockets[socket]->last_frame_size < (SOCKET_OUT_BUFF_SIZE>>1)) return;

  while(n--)
  {
    if(outgoing_packets[n].socket == -1)
    {
      outgoing_packets[n].socket = socket;
      if(len < 60)
      {
        _fmemset(&outgoing_packets[n].packet_buff[len], 0, 60-len);
        len = 60;
      }
      outgoing_packets[n].length = len;
      outgoing_packets[n].id = sockets[socket]->send.psh_count++;
      outgoing_packets[n].payload_size = payload_size;
      sockets[socket]->send.count += sockets[socket]->send.ack_waiting;
      outgoing_packets[n].ack_num = ack_num;
      outgoing_packets[n].last_sent = clock_tick_count();
      sockets[socket]->out_buff_read_offset += sockets[socket]->send.ack_waiting;
      sockets[socket]->status = 1;
      _fmemcpy(outgoing_packets[n].packet_buff, packet, len);
      goto end;
    }
  }
//  sockets[socket]->ploss++;

  end:sockets[socket]->send.retries = 0;
}

inline unsigned find_first_unackd_packet(unsigned socket, unsigned long time)
{
  unsigned n;
  unsigned id = sockets[socket]->send.psh_count;
  unsigned retval = -1;
  for(n=OUT_PACKETS;n--;)
    if(outgoing_packets[n].socket == socket
       && (signed long)(time - outgoing_packets[n].last_sent) > (sockets[socket]->send.latency|1))
    {
      if((signed)(id - outgoing_packets[n].id) > 0)
      {
        id = outgoing_packets[n].id;
        retval = n;
      }
    }
  return retval;
}

static unsigned resend_outpacket4(unsigned socket)
{
  unsigned n;

  if(sockets[socket]->send.retries >= MAX_RETRIES)
    return 1;
  else
  {
    n = find_first_unackd_packet(socket, clock_tick_count());
    if(n == -1)
      return 0;

    sockets[socket]->ploss++;// = INIT_PLOSS;

    if(!send_raw_packet(outgoing_packets[n].packet_buff, outgoing_packets[n].length))
    {
      outgoing_packets[n].last_sent = clock_tick_count();
      sockets[socket]->send.retries++;
    }
    return 1;
  }
}

static unsigned long update_latency(unsigned socket, unsigned long last_send)
{
  unsigned long latency = (clock_tick_count() - last_send)<<1;
  unsigned long __far *slatency = &sockets[socket]->send.latency;

  if(latency > *slatency)
    *slatency = latency;
  else if(latency < *slatency)
    --*slatency;
  return *slatency;
}

static void mark_outpacket_sent(unsigned index)
{
  unsigned socket = outgoing_packets[index].socket;
  unsigned id = outgoing_packets[index].id;
  unsigned p;
  unsigned retries = sockets[socket]->send.retries;

  update_latency(socket, outgoing_packets[index].last_sent);

  for(p=OUT_PACKETS;p--;)
    if(outgoing_packets[p].socket == socket
      && (signed)(id - outgoing_packets[p].id) >= 0)
    {
      outgoing_packets[p].socket = -1;
    }

  if(retries > 1)
  {
    sockets[socket]->send.retries = 0;
    if(!resend_outpacket4(socket))
      tcp4_packetizer(socket);
  }
  else
  {
    sockets[socket]->time = ttime(0);
  }
}

static void socket_delete_buffers(unsigned socket)
{
  unsigned n = OUT_PACKETS;

  while(n--)
    if(outgoing_packets[n].socket == socket)
      outgoing_packets[n].socket = -1;
}

static int out_buffers_free(unsigned socket)
{
  unsigned n = OUT_PACKETS;

  if(too_much_ploss(socket))
    return 0;

  while(n--)
    if(outgoing_packets[n].socket == -1)
      return 1;

  return 0;
}
