#include <stdlib.h>
#include <stdio.h>
//#include <sys/socket.h>
//#include <netinet/in.h>
#include <string.h>

#include <socket.h>

struct sockaddr_in sockstrct;

int listen_socket(unsigned port)
{
  int retval = socket(AF_INET, SOCK_DGRAM | SOCK_NONBLOCK, 0);

  sockstrct.sin_port = (port << 8) | (port >> 8);

  if(bind(retval, &sockstrct, sizeof(struct sockaddr_in)))
  {
    puts("Bind failed");
    return -1;
  }

  listen(retval, 8);

  return retval;
}

void telnet_loop(int sock)
{
  char buff[100];
  int c;
  while(1)
  {
    c = recv(sock, buff, sizeof(buff), 0);
    if(c == -1 || c == 0)
      break;
    fwrite(buff, 1, c, stdout);
    memset(buff, 0, sizeof(buff));
    gets(buff);
    send(sock, buff, strlen(buff), 0);
  }
}

int main(char argc, char *argv[])
{
  unsigned port;
  int sock;
  int accept_size = sizeof(struct sockaddr_in);
  int client_socket;

  if(argc < 2)
  {
    puts("No port");
    return 1;
  }

  port = atoi(argv[1]);

  sock = listen_socket(port);
  if(sock != -1)
  {
    while(1)
    {
      client_socket = accept(sock, &sockstrct, &accept_size);
      if(client_socket != -1)
      {
        telnet_loop(client_socket);
        break;
      }
      else
        puts("Waiting for connection...");
    }
  }
}

