static int send_tcp6(unsigned socket, struct tcp4_header *header, struct tcp4_data *data, char __far *dest_mac)
{
  unsigned total_length;
  struct ipv6_header ipv6_header;
  unsigned char __far *packet;
  unsigned char __far *payload;
  struct ipv6_addr dst = sockets[socket]->ip_addr.ipv6_addr;

  packet = get_free_async_buff();
  payload = &packet[14];

  init_ipv6_packet_header(dst, packet, dest_mac);

  init_ipv6_header_struct(&ipv6_header, 6, dst);

  build_ipv6_header(payload, &ipv6_header);

  total_length = build_tcp4_packet(&payload[40], header, data, (union ip_addr*)&dst, 1);

  ipv6_inject_lengthinfo(payload, total_length);

  if(data && !is_localhost6(&payload[24]))
  {
    if(sockets[socket]->send.window)
    {
      add_outpacket(socket, packet, total_length+14+40, data->len);
    }
    if(data->only_save)
    {
      outpktbuff_inuse = 0xFF;
      return 0;
    }
  }
  sockets[socket]->send.last_send = clock_tick_count();

  return send_ip6_packet(packet, total_length+14+40);
}
