struct longword
{
  unsigned short h, l;
};

struct driver
{
  unsigned handle; // this must be first
  unsigned version;
  unsigned type;
  unsigned char class;
  unsigned char number;
  char name[64];
  unsigned char functionality;
  unsigned char spec_major;
  unsigned char spec_minor;
  unsigned max_sends;
  unsigned hi_perf:1;
  unsigned extended:1;
};

struct raw_packet
{
  unsigned length;
  unsigned char __far * volatile data;
};

struct ipv4_addr
{
  unsigned char p1;
  unsigned char p2;
  unsigned char p3;
  unsigned char p4;
};

struct ipv6_addr
{
  unsigned short p1;
  unsigned short p2;
  unsigned short p3;
  unsigned short p4;
  unsigned short p5;
  unsigned short p6;
  unsigned short p7;
  unsigned short p8;
};

struct ipv4_header_options
{
  unsigned format:1;
  unsigned option_class:2;
  unsigned length;

};

struct ipv4_header_flags
{
  unsigned dont_fragment:1;
  unsigned more_fragments:1;
};

struct ipv4_header
{
  unsigned char type_of_service;
  unsigned short identification;
  struct ipv4_header_flags flags;
  unsigned fragment_offset:13;
  unsigned char time_to_live;
  unsigned char protocol;
  struct ipv4_addr src_address;
  struct ipv4_addr dst_address;
  struct ipv4_header_options options;
};

struct ipv6_header
{
  unsigned payload_length;
  unsigned char time_to_live;
  unsigned char protocol;
  struct ipv6_addr src_address;
  struct ipv6_addr dst_address;
};

struct icmp_echo
{
  unsigned short identifier;
  unsigned short sequence_number;
  unsigned char __far *data;
  unsigned data_len;
};

struct tcp4_data
{
  unsigned char *data;
  unsigned len;
  unsigned only_save:1;
};

struct udp_data
{
  unsigned char *data;
  unsigned len;
};

struct icmp_header
{
  unsigned char type;
  unsigned char code;
};

struct icmp6_header
{
  unsigned char type;
  unsigned char code;
  unsigned checksum;
};

union ip_header
{
  struct ipv4_header ipv4_header;
  struct ipv6_header ipv6_header;
};

struct tcp4_flags
{
  unsigned urg:1;
  unsigned ack:1;
  unsigned push:1;
  unsigned reset:1;
  unsigned syn:1;
  unsigned fin:1;
};

struct tcp4_options
{
  unsigned short max_seg_size;
};

struct tcp4_header
{
  unsigned short src_port;
  unsigned short dst_port;
  unsigned long seq_number;
  unsigned long ack_number;
  unsigned char data_offset;
  struct tcp4_flags flags;
  unsigned short window;
//  unsigned short checksum;
  unsigned short urg_ptr;
//  struct tcp4_options options;
};

struct udp4_header
{
  unsigned short src_port;
  unsigned short dst_port;
  unsigned short len;
//  unsigned short checksum;
};

union payload_protocol_header
{
  struct icmp_header icmp_header;
  struct tcp4_header tcp4_header;
  struct udp4_header udp4_header;
  struct icmp6_header icmp6_header;
};

union payload_data
{
  struct icmp_echo icmp_echo;
  struct tcp4_data tcp4_data;
  struct udp_data udp_data;
};

struct incoming_packet
{
  unsigned char sender_mac[6];
  unsigned ipv6:1;
  int error;
  union ip_header ip_header;
  union payload_protocol_header payload_header;
  union payload_data data;
};

union ip_addr
{
  struct ipv4_addr ipv4_addr;
  struct ipv6_addr ipv6_addr;
};

struct tcp_send
{
  unsigned long iss;
  unsigned long count;
  unsigned long last_send;
  unsigned long latency;
  unsigned ack_waiting;
  unsigned window;
  unsigned retries;
  unsigned psh_count;
  unsigned zerowindow:1;
};

struct tcp_recv
{
  unsigned long irs;
  unsigned long count;
  unsigned last_len;
  unsigned zerowindow:1;
};

struct transmission_control_block
{
  unsigned short local_port;
  unsigned udp:1; // 0 = tcp
  unsigned ipv6:1; // must be offset identical to open_port_control_block for getsockname()
  // incoming connection
  unsigned accepted:1;
//  unsigned nodelay:1;
  // status == 0: connection handshake
  // status == 1: connection established
  // status == 2: packet sent, waiting for ack
  // status == 3: FIN sent, waiting for ack
  unsigned status:2;
#ifdef TCP_RETRANS_ANSWER_DELAY
  // 1: SYN-ACK needs to be reanswered
  unsigned first_ack_retrans:1;
#endif
  // connection is closed, but read buffer contains data.
  unsigned data_pending:1;
  // connection is closed, but write buffer contains data that needs to be sent.
  unsigned send_pending:1;
  // 0 = no raw socket, 2 = raw socket with IPv4, 1 = raw socket with ipv6,
  // 3 = completely raw socket
  unsigned raw:2;
  unsigned char raw_protocol;
  unsigned last_frame_size;
  struct tcp_send send;
  struct tcp_recv recv;
  unsigned short remote_port;
  unsigned char remote_addr[6];
  union ip_addr ip_addr;
  unsigned char in_buff[SOCKET_IN_BUFF_SIZE];
  unsigned in_buff_write_offset;
  unsigned in_buff_read_offset;
  unsigned char out_buff[SOCKET_OUT_BUFF_SIZE];
  unsigned out_buff_write_offset;
  unsigned out_buff_read_offset;
  unsigned long time;
  unsigned long user_closed;
  int socket_descriptor;
  unsigned char ploss;
  unsigned char ploss_chg;
};

struct out_packet
{
  unsigned char packet_buff[OUT_PACKET_SIZE];
  unsigned socket;
  unsigned long ack_num;
  unsigned long last_sent;
  unsigned length;
  unsigned payload_size;
  unsigned id;
};

struct open_port_control_block
{
  unsigned short local_port;
  unsigned udp:1;
  unsigned ipv6:1;
  unsigned ipv_matters:1;
  int socket_descriptor;
  unsigned socket_queue[SOCKET_QUEUE_LEN];
  unsigned socket_queue_count;
};

union portsock
{
  struct transmission_control_block sock;
  struct open_port_control_block port;
};

struct dns_query
{
  unsigned long time;
  union ip_addr ip_addr;
  unsigned short id;
  unsigned len;
  unsigned nameptr;
  unsigned time_to_live;
  unsigned local_port;
  unsigned inverse:1;
  unsigned answered:1;
  unsigned noerror:1;
  unsigned ipv6:1;
  char dns[DNS_NAME_LEN+1];
};

struct mac_cache
{
  unsigned char mac[6];
  char type; // 0 = ipv4, 1 = ipv6
  union ip_addr ip_addr;
  unsigned long timestamp;
};

struct sockaddr_in
{
  unsigned short sin_family;
  unsigned short sin_port; // !!! BID ENDIAN !!!
  unsigned char sin_addr[4]; // !!! BIG ENDIAN !!!
  char sin_zero;
};

struct sockaddr_in6
{
  unsigned short sin6_family;
  unsigned short sin6_port; // !!! BIG ENDIAN !!!
  unsigned long sin6_flowinfo;
  unsigned char sin6_addr[16]; // endianness?
  
};

union sockaddr
{
  struct sockaddr_in sockaddr_in;
  struct sockaddr_in6 sockaddr_in6;
};

struct loopback
{
  struct raw_packet packet;
  unsigned has_data:1;
  unsigned processing:1;
};

struct dhcp
{
  unsigned long id;
  unsigned long lease_end_time;
  unsigned long request_time;
  unsigned time_elapsed;
  signed status:4;
  unsigned user_dns:1;
};

struct dhcp6
{
  unsigned long lease_end_time;
  unsigned long request_time;
  unsigned long transaction_id;
  unsigned long iaid;
  unsigned long start_time;
  unsigned time_elapsed;
  unsigned char server_identifier_len;
  unsigned char server_identifier[128];
//  unsigned char identity_association[40];
  struct ipv6_addr server_addr;
  signed status:5;
  unsigned user_dns:1;
  unsigned use_dhcp6:1;
};

struct nd_struct
{
  struct ipv6_addr __far *target_addr;
  unsigned char __far *target_mac;
};
