#include <stdlib.h>
#include <socket.h>
#include <string.h>
#include <dos.h>

struct socket
{
  unsigned sock_desc;
  unsigned type;
  struct socket *next;
  struct socket *prev;
  int sock_id;
  unsigned ipv6:1;
};

static struct socket *first_socket = 0;

static struct socket *get_sock_struct(unsigned socket)
{
  struct socket *s = first_socket;
  while(s)
  {
    if(s->sock_id == socket)
      break;
    s = s->next;
  }
  return s;
}

static unsigned get_sock_desc(unsigned socket)
{
  struct socket *s = get_sock_struct(socket);
  if(s) return s->sock_desc;
  return -1;
}

static void remove_sock_struct(unsigned socket)
{
  struct socket *s = get_sock_struct(socket);

  if(s->prev)
    s->prev->next = s->next;
  if(s->next)
    s->next->prev = s->prev;
  free(s);
  if(s == first_socket)
    first_socket = 0;
}

static struct socket *add_sock_struct(void)
{
  struct socket *s;
  struct socket *new = calloc(1, sizeof(struct socket));

  if(!new) return 0;

  while(get_sock_struct(new->sock_id))
    new->sock_id++;

  if(first_socket)
  {
    s = first_socket;
    while(s->next) s = s->next;
    s->next = new;
    new->prev = s;
  }
  else
    first_socket = new;

  return new;
}

int close_socket(int socket)
{
  int retval;
  int sock_desc = get_sock_desc(socket);

  __asm
  {
    mov ax, 4
    mov bx, sock_desc
    int 0x61
    mov retval, ax
  }

  remove_sock_struct(socket);

  return retval;
}

static void close_all_sockets(void)
{
  struct socket *s = first_socket;
  struct socket *next;

  while(s)
  {
    next = s->next;
    close_socket(s->sock_id);
    s = next;
  }
}

//void __far *old_int23_handler;

volatile unsigned char break_pressed = 0;

static void __interrupt int23_handler(void)
{
  break_pressed = 1;
}

void call_break(void);
#pragma aux call_break = \
  "int 0x23";

void set_idle_int(void);
#pragma aux set_idle_int = \
  "mov ax, 25" \
  "int 0x61";

int initialize_tcp(void)
{
  set_idle_int();

//  old_int23_handler = _dos_getvect(0x23);
  _dos_setvect(0x23, int23_handler);

  return 0;
}

void unset_idle_int(void);
#pragma aux unset_idle_int = \
  "mov ax, 26" \
  "int 0x61";

static void handle_break(void)
{
  exit(0);
}


void service_packets(void);
#pragma aux service_packets = \
  "xor ax, ax" \
  "int 0x61";

int get_socket_status(unsigned socket);
#pragma aux get_socket_status = \
  "mov ax, 8" \
  "int 0x61" \
  value [ax] parm [bx];

static void uninitialize_tcp(void)
{
  unset_idle_int();
}

int socket(int domain, int type, int protocol)
{
  static char init = 0;
  int retval;
  struct socket *s;

  if(!_dos_getvect(0x61))
  {
    return -1;
  }

  s = add_sock_struct();

  if(!s) return -1;

  s->type = type;
  if(!(type & 0x8000))
    type &= 1;

  __asm
  {
    mov ax, 9
    mov bx, domain
    mov cx, type
    mov dx, protocol
    int 0x61
    mov retval, ax
  }

  if(retval == -1)
  {
    remove_sock_struct(s->sock_id);
    return -1;
  }

  s->sock_desc = retval;
  s->ipv6 = domain;

  if(!init)
  {
    initialize_tcp();
    atexit(close_all_sockets);
    atexit(uninitialize_tcp);
    init++;
  }

  return s->sock_id;
}

int bind(int sockfd, const struct sockaddr __far *addr, unsigned addrlen)
{
  int retval;

  sockfd = get_sock_desc(sockfd);

  if(sockfd == -1) return -1;

  __asm
  {
    mov ax, 10
    mov bx, sockfd
    mov cx, addrlen
    les dx, addr
    int 0x61
    mov retval, ax
  }

  return retval;
}

int connect(int sockfd, const struct sockaddr __far *addr, unsigned addrlen)
{
  int retval;
  int status;

  sockfd = get_sock_desc(sockfd);

  if(sockfd == -1) return -1;

  __asm
  {
    mov ax, 11
    mov bx, sockfd
    les dx, addr
    int 0x61
    mov retval, ax
  }
  
  do
    service_packets();
  while(!(status = get_socket_status(sockfd)));

  if(status == -1) return -1;

  return retval;
}

int listen(int sockfd, int backlog)
{
  int retval;

  sockfd = get_sock_desc(sockfd);

  if(sockfd == -1) return -1;

  __asm
  {
    mov ax, 27
    mov bx, sockfd
    int 0x61
    mov retval, ax
  }

  return retval;
}

int setpeername(int sockfd, const struct sockaddr __far *addr, unsigned addrlen)
{
  int retval;

  sockfd = get_sock_desc(sockfd);

  if(sockfd == -1) return -1;

  __asm
  {
    mov ax, 29
    mov bx, sockfd
    les dx, addr
    int 0x61
    mov retval, ax
  }

  return retval;
}

int getpeername(int sockfd, struct sockaddr __far *addr, unsigned *addrlen)
{
  unsigned max_len = *addrlen;
  int retval;

  sockfd = get_sock_desc(sockfd);

  if(sockfd == -1) return -1;

  __asm
  {
    mov ax, 12
    mov bx, sockfd
    les dx, addr
    mov cx, max_len
    int 0x61
    mov retval, ax
  }

  if(retval > max_len)
  {
    *addrlen = retval;
    return 0;
  }

  return retval;
}

int getsockname(int sockfd, struct sockaddr __far *addr, unsigned *addrlen)
{
  unsigned maxlen = *addrlen;
  int retval;

  sockfd = get_sock_desc(sockfd);

  if(sockfd == -1) return -1;

  __asm
  {
    mov ax, 28
    mov bx, sockfd
    les dx, addr
    mov cx, addrlen
    int 0x61
    mov retval, ax
  }

  if(retval > maxlen)
  {
    *addrlen = retval;
    return 0;
  }

  return retval;

}

#define MSG_DONTWAIT 0x01

int recv(int sockfd, void __far *buf, unsigned len, int flags)
{
  int retval;
  struct socket *s = get_sock_struct(sockfd);

  if(!s) return -1;

  sockfd = s->sock_desc;

  do
  {
    service_packets();

    __asm
    {
      mov ax, 2
      mov bx, sockfd
      les dx, buf
      mov cx, len
      int 0x61
      mov retval, ax
    }

    if(break_pressed)
    {
      handle_break();
    }

  }
  while(!retval && !(flags & MSG_DONTWAIT) && !(s->type & SOCK_NONBLOCK));

  if(!retval && ((flags & MSG_DONTWAIT) || (s->type & SOCK_NONBLOCK)))
  {
    errno = EWOULDBLOCK;
    return -1;
  }

  return retval;
}

int accept_flags = 0;

int accept(int sockfd, struct sockaddr __far *addr, unsigned *addrlen)
{
  int retval;
  int rc;
  struct socket *s;

  rc = recv(sockfd, &retval, 2, accept_flags);

  if(rc == 2)
  {
    s = add_sock_struct();
    if(!s) return -1;
    s->sock_desc = retval;
    retval = s->sock_id;
    getpeername(retval, addr, addrlen);
  }
  else return -1;

  return retval;
}

int send(int sockfd, const void __far *buf, unsigned len, int flags)
{
  int retval;
  struct socket *s = get_sock_struct(sockfd);

  if(!s) return -1;

  sockfd = s->sock_desc;

  do
  {
    __asm
    {
      mov ax, 3
      mov bx, sockfd
      les dx, buf
      mov cx, len
      int 0x61
      mov retval, ax
    }
    service_packets();

    if(break_pressed)
    {
      handle_break();
    }
  }
  while(!retval && !(flags & MSG_DONTWAIT) && !(s->type & SOCK_NONBLOCK));

  return retval;
}

unsigned sendto(int sockfd, const void __far *buf, unsigned len, int flags,
                const struct sockaddr __far *dest_addr, unsigned addrlen)
{
  struct socket *sock = get_sock_struct(sockfd);
  unsigned sock_type;
  struct sockaddr_in6 addr_struct;
  unsigned retval;
  unsigned sockaddr_size;
//  int temp_socket_1;

  if(!sock) return -1;

  if(!sock->ipv6) sockaddr_size = sizeof(struct sockaddr_in);
  else sockaddr_size = sizeof(struct sockaddr_in6);

  sock_type = sock->type;

  if(!(sock_type & SOCK_DGRAM)) return -1; // not an UDP socket

  // temporarily save the current peer address
  getpeername(sockfd, &addr_struct, &sockaddr_size);
  // change the current peer address to dest_addr
  setpeername(sockfd, dest_addr, addrlen);
  // send the data
  retval = send(sockfd, buf, len, flags);
  // restore the peer address
  setpeername(sockfd, &addr_struct, addrlen);

/*  temp_socket_1 = socket(AF_INET, sock_type, 0);
  if(temp_socket_1 == -1) return -1; // out of resources, cannot create temporary socket

  // connect the temporary socket to the given remote address
  connect(temp_socket_1, dest_addr, addrlen);

  // bind the temporary socket to the same local address as the original socket
  getsockname(sockfd, &addr_struct, &sockaddr_size);
  bind(temp_socket_1, &addr_struct, sockaddr_size);

  // send the data
  retval = send(temp_socket_1, buf, len, flags);

  // close the temporary socket
  close_socket(temp_socket_1);*/

  return retval;
}

unsigned recvfrom(int sockfd, void __far *buf, unsigned len, int flags,
                  struct sockaddr __far *src_addr, unsigned *addrlen)
{
  struct socket *sock = get_sock_struct(sockfd);
  unsigned sock_type;
  struct sockaddr_in6 addr_struct;
  unsigned retval;
  unsigned sockaddr_size;

//  int temp_socket_1, temp_socket_2;

  if(!sock) return -1;

  if(!sock->ipv6)
    sockaddr_size = sizeof(struct sockaddr_in);
  else
    sockaddr_size = sizeof(struct sockaddr_in6);

  sock_type = sock->type;

  if(!(sock_type & SOCK_DGRAM)) return -1; // not an UDP socket

  memset(&addr_struct, 0, sizeof(addr_struct));

  setpeername(sockfd, &addr_struct, sockaddr_size);
  retval = recv(sockfd, buf, len, flags);
  getpeername(sockfd, src_addr, addrlen);

  /*
  // if the remote address of the
  // socket is already the same as in *src_addr, use this original socket
  // for receiving
  if(!_fmemcmp(&addr_struct, src_addr, sizeof(struct sockaddr_in)))
    return recv(sockfd, buf, len, flags);

  // else create a temporary socket for listening
  temp_socket_1 = socket(AF_INET, sock_type, 0);
  if(temp_socket_1 == -1) return -1; // out of resources

  // bind the temporary socket to the same local address
  getsockname(sockfd, &addr_struct, &sockaddr_size);
  bind(temp_socket_1, &addr_struct, sockaddr_size);

  // test that there is enough memory available for a second socket
  temp_socket_2 = socket(AF_INET, sock_type, 0);
  if(temp_socket_2 != -1)
  {
    close_socket(temp_socket_2);
    // wait for an incoming connection
    listen(temp_socket_1, 0);
    accept_flags = flags;
    temp_socket_2 = accept(temp_socket_1, src_addr, addrlen);
    accept_flags = 0;
    if(temp_socket_2 != -1)
    {
      // receive data
      retval = recv(temp_socket_2, buf, len, flags);
  
      // close the temporary sockets
      close_socket(temp_socket_2);
    }
    else
      retval = -1;
  }
  else retval = -1;
  close_socket(temp_socket_1);*/

  return retval;
}
