struct in_addr
{
  unsigned long s_addr;
};

struct sockaddr_in
{
  unsigned short sin_family;
  unsigned short sin_port;
  struct in_addr sin_addr;
  char sin_zero[8];
};

struct in6_addr
{
  unsigned char s6_addr[16];
};

struct sockaddr_in6
{
  unsigned short sin6_family;
  unsigned short sin6_port;
  unsigned long sin6_flowinfo;
  struct in6_addr sin6_addr;
};

struct sockaddr
{
  unsigned short sa_family;
  char sa_data[14];
};

int close_socket(int socket);

#define SOCK_NONBLOCK 2

void _service_packets(void);
#pragma aux _service_packets = \
  "xor ax, ax" \
  "int 0x61";

#define AF_INET 0
#define AF_INET6 1

#define SOCK_STREAM 0
#define SOCK_DGRAM 1
#define SOCK_RAW ((int)0x8003)
#define SOCK_RAW_IP4 ((int)0x8002)
#define SOCK_RAW_IP6 ((int)0x8001)

#define INADDR_ANY 0

#define EBADF 254
#define ECONNRESET 253
#define ENOTCONN 252
#define EWOULDBLOCK 255
#define EAGAIN EWOULDBLOCK

int socket(int domain, int type, int protocol);

int bind(int sockfd, const struct sockaddr __far *addr, unsigned addrlen);

int connect(int sockfd, const struct sockaddr __far *addr, unsigned addrlen);

int listen(int sockfd, int backlog);

int getpeername(int sockfd, struct sockaddr __far *addr, unsigned *addrlen);

int setpeername(int sockfd, const struct sockaddr __far *addr, unsigned addrlen);

int getsockname(int sockfd, struct sockaddr __far *addr, unsigned *addrlen);

#define MSG_DONTWAIT 0x01

int recv(int sockfd, void __far *buf, unsigned len, int flags);

unsigned recvfrom(int sockfd, void __far *buf, unsigned len, int flags,
                  struct sockaddr __far *src_addr, unsigned *addrlen);

int accept(int sockfd, struct sockaddr __far *addr, unsigned *addrlen);

int send(int sockfd, const void __far *buf, unsigned len, int flags);

unsigned sendto(int sockfd, const void __far *buf, unsigned len, int flags,
                const struct sockaddr __far *dest_addr, unsigned addrlen);
