/*#include "defines.c"
#include "structs.c"
#include "externs.c"*/

// find index number of free raw packet descriptor.
// return -1 if fails
inline int find_free_raw_packet_index(void)
{
  int retval = raw_packet_index & (RAW_PACKET_COUNT-1);
  if(raw_packet[retval].data)
    return -1;
  raw_packet_index++;
  return retval;
}

inline int register_packet(unsigned char __far *data, unsigned length)
{
  int index = find_free_raw_packet_index();

  if(index == -1)
  {
    rx_dropped_packets++;
    return -1; // raw packet descriptors full, drop packet
  }

  raw_packet[index].data = data;
  raw_packet[index].length = length;

  raw_packet_endindex += length;
  raw_packet_endindex &= RAW_PACKET_BUFFER_MAX;

  return 0;
}

unsigned __based (__segname("_CODE")) raw_buffer_free;

inline struct raw_packet __far * incoming_buffer_free_block(void)
{
  unsigned start_space, end_space;
  static struct raw_packet __based (__segname("_CODE")) retval;

  if(raw_packet_startindex > raw_packet_endindex)
  {
    retval.length = RAW_PACKET_BUFFER_MAX - raw_packet_startindex;
    retval.data = &input_buffer[raw_packet_startindex];
  }

  else
  {
    start_space = raw_packet_startindex;
    end_space = RAW_PACKET_BUFFER_MAX - raw_packet_endindex;
    
    if(end_space > start_space)
    {
      retval.length = end_space;
      retval.data = &input_buffer[raw_packet_endindex];
    }
    else
    {
      retval.length = start_space;
      retval.data = input_buffer;
    }
  }

  raw_buffer_free = retval.length;

  return &retval;
}

void __far * receiver(unsigned phase, unsigned length);
#pragma aux receiver parm [ax] [cx] value [es di] modify exact [];

void __far * receiver(unsigned phase, unsigned length)
{
  static struct raw_packet __far * __based (__segname("_CODE")) free_block;
  
  if(!phase)
  {
    free_block = incoming_buffer_free_block();
    if(length > free_block->length)
    {
      rx_dropped_packets++; // no space for the packet
      return 0;
    }
    receiving_packet++;
  }
  else
  {
    register_packet(free_block->data, length);
    rx_packets++;
    rx_bytes += length;
    receiving_packet--;
  }

  return free_block->data;
}

void __far upcall(char __far *);
#pragma aux upcall parm [es di];
void __far upcall(char __far *buff)
{
  if(buff[7])
    tx_error_count++;
  transmission_flag--;
}

