

static void send_icmp(struct ipv4_addr dst, struct icmp_header *icmp_header, struct icmp_echo *icmp_echo)
{
  unsigned total_length;
  unsigned ipv4_header_length;
  struct ipv4_header ipv4_header;  
  unsigned char __far *packet;
  unsigned char __far *payload;

  packet = get_free_async_buff();
  payload = &packet[14];

  init_ipv4_packet_header(dst, packet, 0);

  ipv4_header.type_of_service = 0;
  ipv4_header.identification = random();
  ipv4_header.flags.dont_fragment = 0;
  ipv4_header.flags.more_fragments = 0;
  ipv4_header.fragment_offset = 0;
  ipv4_header.time_to_live = 0xFF;
  ipv4_header.protocol = 1;

  ipv4_header.src_address = ipv4_my_addr;
  ipv4_header.dst_address = dst;  

  ipv4_header_length = build_ipv4_header(payload, &ipv4_header);

  total_length = ipv4_header_length + build_icmp_packet(&payload[ipv4_header_length], icmp_header, icmp_echo);
  ipv4_inject_lengthinfo(payload, total_length);
  ipv4_inject_header_checksum(payload, ipv4_header_length);  

  send_ip_packet(packet, total_length+14);
}

static void respond_ping(struct incoming_packet *request)
{
  if(!request->ipv6)
  {
    request->payload_header.icmp_header.type = 0;
    send_icmp(request->ip_header.ipv4_header.src_address, &request->payload_header.icmp_header, &request->data.icmp_echo);  
  }
  else
  {
    request->payload_header.icmp6_header.type++;
    send_pong6(&request->ip_header.ipv6_header.src_address, &request->payload_header.icmp6_header, &request->data.icmp_echo);
  }
}

/*static struct icmp_echo request_ping(struct ipv4_addr dst)
{
  struct icmp_header icmp_header;
  struct icmp_echo icmp_echo;
  static unsigned char __based (__segname("_CODE")) icmp_data[64] = "ABCDEFGHIJKLMNabcdefghijklmn1234567890";

  icmp_header.type = 8;
  icmp_header.code = 0;

  icmp_echo.identifier = random();
  icmp_echo.sequence_number = random();
  icmp_echo.data = icmp_data;
  icmp_echo.data_len = 64;


  send_icmp(dst, &icmp_header, &icmp_echo);

  return icmp_echo;
}
*/
