static void create_multicast_address(struct ipv6_addr __far *source,
                                       struct ipv6_addr __far *target)
{
  target->p1 = 0x02FF;
  target->p6 = 0x0100;
  target->p7 = 0x00FF | (source->p7 & 0xFF00);
  target->p8 = source->p8;
}

static int is_ipv6_multicast(struct ipv6_addr *address)
{
  if((address->p1 & 0xF0FF) == 0xFF)
    return 1;
  return 0;
}

static int address_in_same_ipv6_subnet(struct ipv6_addr *address)
{
  unsigned char n = ipv6_network_prefix >> 3;
  unsigned char b;
  unsigned mask;

  if(_fmemcmp(address, &ipv6_local_addr, n))
    return 0;

  b = ipv6_network_prefix & 0xF;
  if(b)
  {
    n >>= 1;
    mask = -1 >> b;
    if((((unsigned *)address)[n] & mask)
       != (((unsigned __far*)&ipv6_local_addr)[n] & mask))
      return 0;
  }

  return 1;
}

static int ipv6_point_my_addr(struct ipv6_addr *addr)
{
  if(!_fmemcmp(addr, &ipv6_global_addr, 16)
     || !_fmemcmp(addr, &ipv6_global_multicast, 16))
    ipv6_my_addr = &ipv6_global_addr;
  else if(!_fmemcmp(addr, &ipv6_local_addr, 16)
        || !_fmemcmp(addr, &nd6_multicast, 16)
        || !_fmemcmp(addr, &ipv6_all_nodes, 16))
    ipv6_my_addr = &ipv6_local_addr;
  else return 1;

  return 0;
}

static struct ipv6_addr __based(__segname("_CODE")) *choose_local_address(struct ipv6_addr *remote_addr)
{
  if(!_fmemcmp(remote_addr, &ipv6_global_multicast, 16))
    return ipv6_my_addr = &ipv6_unspec_addr;
  else if(address_in_same_ipv6_subnet(remote_addr) || is_ipv6_multicast(remote_addr))
    return ipv6_my_addr = &ipv6_local_addr;
  else
    return ipv6_my_addr = &ipv6_global_addr;
}

static void init_ipv6_header_struct(struct ipv6_header *header, unsigned char protocol, struct ipv6_addr remote_addr)
{
  header->time_to_live = 0xFF;
  header->protocol = protocol;
  header->src_address = *choose_local_address(&remote_addr);
  header->dst_address = remote_addr;
}

static void build_ipv6_header(unsigned char __far *header, struct ipv6_header *headstruct)
{
  *(unsigned long __far*)&header[0] = (unsigned long)6 << 4;
  header[6] = headstruct->protocol;
  header[7] = headstruct->time_to_live;

//  ipv6_point_my_addr(&headstruct->src_address);

  _fmemcpy(&header[8], &headstruct->src_address, 16);
  _fmemcpy(&header[24], &headstruct->dst_address, 16);

//  return 40; // length of header
}

static void ipv6_inject_lengthinfo(unsigned char __far *packet, unsigned length)
{
  *(unsigned short __far*)&packet[4] = switch_endianness_s(length);
}

static unsigned short __far *ipv6_pseudoheader(struct ipv6_addr src_addr, struct ipv6_addr dst_addr, unsigned len, unsigned char protocol)
{
  unsigned char __far *retval = pseudoheader;
  unsigned long __far *lenptr = (unsigned long __far*)&retval[32];

  _fmemcpy(retval, &src_addr, 16);
  _fmemcpy(&retval[16], &dst_addr, 16);

  *lenptr = switch_endianness_l(len);

  lenptr[1] = switch_endianness_l(protocol);

  return (unsigned short __far*)retval;
}

static int is_localhost6(void __far *addr)
{
  unsigned __far *ptr = addr;
  unsigned n;

  for(n=7;n--;)
    if(*ptr++) return 0;

  if(switch_endianness_s(*ptr) == 1)
    return 1;

  return 0;
}

static void ipv6_multicast_mac(struct ipv6_addr __far *ipv6_addr, unsigned char __far *mac)
{
  *(unsigned *)mac = 0x3333;
  *(unsigned long*)&mac[2] = *(unsigned long*)&ipv6_addr->p7;
}

static void strtoipv6(struct ipv6_addr __far *ipv6_addr, unsigned char *str)
{
  unsigned p;
  unsigned __far *pptr = (unsigned __far*)ipv6_addr;
  unsigned char *ptr;
  unsigned char h, l;

  _fmemset(ipv6_addr, 0, sizeof(struct ipv6_addr));

  for(p=0;p<8;p++)
  {
    if(*str == ':')
    {
      if(!p) str++;
      for(p=0,ptr=++str;*ptr;ptr++)
        if(*ptr == ':') p++;
      p = 7 - p;
    }


    ptr = strchr(str, ':');
    if(!ptr)
    {
      ptr = strchr(str, 0);
      if(ptr == str) break;
    }
    if(ptr-str == 4)
      pptr[p] = strtohex(str) | (strtohex(str+2) << 8);
    else if(ptr-str == 3)
    {
      h = strtohex(str) >> 4;
      l = strtohex(str+1);
      pptr[p] = (l << 8) | h;
    }
    else
      pptr[p] = strtohex(str) << 8;

    if(!*ptr) break;
    str = ptr+1;
 
  }
}

