// Arguments: DNS (or IP) address, remote port, and is the connection UDP type or not (1 == yes).
// Returns -1 if the domain name is not resolved, and a socket descriptor if is.
// How to use: Call this function in a loop until it doesn't return -1.

int connect(char *dns, unsigned port, char udp)
{
  unsigned d = send_dns4_req(ipv4_dns, dns);
  unsigned local_port;
  unsigned s;

  if(!dns_cache[d].answered)
  {
    error_code = ENOTCONN;
    return -1;
  }
  if(!dns_cache[d].noerror)
  {
    error_code = HOST_NOT_FOUND;
    return -1;
  }
  local_port = get_free_port(udp, &dns_cache[d].ip_addr, port, dns_cache[d].ipv6);
  if(!udp)  
    s = new_tcp_socket(d, port, local_port);
  else
    s = new_udp_socket(d, port, local_port);

  if(s == -1) return -1;

  return sockets[s]->socket_descriptor;
}
