/*extern struct transmission_control_block __far* __far* \
__based(__segname("_CODE")) sockets;
extern struct open_port_control_block __far* __far* \
__based(__segname("_CODE")) open_ports;*/


unsigned get_memory_allocation_strategy(void);
#pragma aux get_memory_allocation_strategy = \
  "mov ax, 0x5800" \
  "int 0x21" \
  value [ax];

unsigned set_memory_allocation_strategy(unsigned);
#pragma aux set_memory_allocation_strategy = \
  "mov ax, 0x5801" \
  "int 0x21" \
  value [ax] parm [bx];

void __far *alloc_high(unsigned size)
{
  set_memory_allocation_strategy(2);
  return tcpmalloc(size);
}

void __far *alloc_low(unsigned size)
{
  set_memory_allocation_strategy(0);
  return tcpmalloc(size);
}

#pragma aux defrag_memory modify exact [];
void defrag_memory(void)
{
  unsigned n,s;
  void __far *tmpptr;
  unsigned char old_strategy;

  old_strategy = get_memory_allocation_strategy();

  tmpptr = alloc_high(MAX_SOCKETS*sizeof(struct transmission_control_block __far*));
  if(tmpptr)
  {
    _fmemcpy(tmpptr, sockets, MAX_SOCKETS*sizeof(struct transmission_control_block __far*));
    tsr_free(sockets);
    sockets = alloc_low(MAX_SOCKETS*sizeof(struct transmission_control_block __far*));
    _fmemcpy(sockets, tmpptr, MAX_SOCKETS*sizeof(struct transmission_control_block __far*));
    tsr_free(tmpptr);
  }

  tmpptr = alloc_high(MAX_OPEN_PORTS*sizeof(struct open_port_control_block __far*));
  if(tmpptr)
  {
    _fmemcpy(tmpptr, open_ports, MAX_OPEN_PORTS*sizeof(struct open_port_control_block __far*));
    tsr_free(open_ports);
    open_ports = alloc_low(MAX_OPEN_PORTS*sizeof(struct transmission_control_block __far*));
    _fmemcpy(open_ports, tmpptr, MAX_OPEN_PORTS*sizeof(struct transmission_control_block __far*));
    tsr_free(tmpptr);
  }

  tmpptr = alloc_high(OUT_PACKET_SIZE);
  if(tmpptr)
  {
    _fmemcpy(tmpptr, loopback.packet.data, OUT_PACKET_SIZE);
    tsr_free(loopback.packet.data);
    loopback.packet.data = alloc_low(OUT_PACKET_SIZE);
    _fmemcpy(loopback.packet.data, tmpptr, OUT_PACKET_SIZE);
    tsr_free(tmpptr);
  }

  tmpptr = alloc_high(DNS_CACHE_SIZE * sizeof(struct dns_query));
  if(tmpptr)
  {
    _fmemcpy(tmpptr, dns_cache, DNS_CACHE_SIZE*sizeof(struct dns_query));
    tsr_free(dns_cache);
    dns_cache = alloc_low(DNS_CACHE_SIZE * sizeof(struct dns_query));
    _fmemcpy(dns_cache, tmpptr, DNS_CACHE_SIZE*sizeof(struct dns_query));
    tsr_free(tmpptr);
  }

  tmpptr = alloc_high(OUT_PACKETS*sizeof(struct out_packet));
  if(tmpptr)
  {
    _fmemcpy(tmpptr, outgoing_packets, OUT_PACKETS*sizeof(struct out_packet));
    tsr_free(outgoing_packets);
    outgoing_packets = alloc_low(OUT_PACKETS*sizeof(struct out_packet));
    _fmemcpy(outgoing_packets, tmpptr, OUT_PACKETS*sizeof(struct out_packet));
    tsr_free(tmpptr);
  }


  if(!receiving_packet)
  {
    tmpptr = alloc_high(RAW_PACKET_BUFFER<<4);
    if(tmpptr)
    {
      _fmemcpy(tmpptr, input_buffer, RAW_PACKET_BUFFER<<4);
      tsr_free(input_buffer);
      input_buffer = alloc_low(RAW_PACKET_BUFFER<<4);
      _fmemcpy(input_buffer, tmpptr, RAW_PACKET_BUFFER<<4);
      tsr_free(tmpptr);
    }
  }

  if(!transmission_flag)
  {
    if(!driver.hi_perf)
      s = OUT_PACKET_SIZE;
    else
      s = OUT_PACKET_SIZE+24;
    for(n=driver.max_sends;n--;)
    {
      if(outpktbuff_inuse != n)
      {
        tmpptr = alloc_high(s);
        if(tmpptr)
        {
          _fmemcpy(tmpptr, out_pkt_buffs[n], s);
          tsr_free(out_pkt_buffs[n]);
          out_pkt_buffs[n] = alloc_low(s);
          _fmemcpy(out_pkt_buffs[n], tmpptr, s);
          tsr_free(tmpptr);
        }
      }
    }
  }

  for(n=0;n<MAX_SOCKETS;n++)
    if(sockets[n])
    {
      tmpptr = alloc_high(sizeof(struct transmission_control_block));
      if(tmpptr)
      {
        _fmemcpy(tmpptr, sockets[n], sizeof(struct transmission_control_block));
        tsr_free(sockets[n]);
        sockets[n] = alloc_low(sizeof(struct transmission_control_block));
        _fmemcpy(sockets[n], tmpptr, sizeof(struct transmission_control_block));
        tsr_free(tmpptr);
      }
    }
  for(n=0;n<MAX_OPEN_PORTS;n++)
    if(open_ports[n])
    {
      tmpptr = alloc_high(sizeof(struct open_port_control_block));
      if(tmpptr)
      {
        _fmemcpy(tmpptr, open_ports[n], sizeof(struct open_port_control_block));
        tsr_free(open_ports[n]);
        open_ports[n] = alloc_low(sizeof(struct open_port_control_block));
        _fmemcpy(open_ports[n], tmpptr, sizeof(struct open_port_control_block));
        tsr_free(tmpptr);
      }
    }

  set_memory_allocation_strategy(old_strategy);
}
