static void init_arp_header(unsigned char *packet, void __far *dst_mac)
{
  _fmemcpy((void __far*)packet, dst_mac, 6);

  _fmemcpy((void __far*)&packet[6], (void __far*)my_mac, 6);

  packet[12] = 0x08;
  packet[13] = 0x06;
}

static void reply_arp4(unsigned char __far *packet)
{
  unsigned char __far *source_mac = packet;
  unsigned char __far *source_ip = &packet[6];
  unsigned char __far *unknown_ip = &packet[16];
  unsigned char replypkt[60];
  unsigned char *reply = &replypkt[14];
  unsigned short *shortptr = (void*)reply; 

/*  if(unknown_ip[0] != ipv4_my_addr.p1 ||
     unknown_ip[1] != ipv4_my_addr.p2 ||
     unknown_ip[2] != ipv4_my_addr.p3 ||
     unknown_ip[3] != ipv4_my_addr.p4)*/
  if(_fmemcmp(unknown_ip, &ipv4_my_addr, 4))
       return;

  init_arp_header(replypkt, source_mac);

  shortptr[0] = switch_endianness_s(1);
  shortptr[1] = switch_endianness_s(0x0800);
  reply[4] = 6;
  reply[5] = 4;

  shortptr[3] = switch_endianness_s(2);
  

  _fmemcpy(&reply[8], my_mac, 6);
  _fmemcpy(&reply[14], unknown_ip, 4);

  _fmemcpy(&reply[18], source_mac, 6);
  _fmemcpy(&reply[24], source_ip, 4);

  memset(&reply[28], 0, 18);

  send_raw_packet(replypkt, 60);
}

static void add_to_arp_cache4(union ip_addr address, char __far *mac, char ipv6)
{
  static unsigned int __based(__segname("_CODE")) arp_cache_index = 0;
  unsigned index = arp_cache_index++ & (ARP_CACHE_SIZE-1);

  arp_cache[index].type = ipv6;
  _fmemcpy(&arp_cache[index].ip_addr, &address, 16);
  _fmemcpy(arp_cache[index].mac, mac, 6);
  arp_cache[index].timestamp = ttime(0);
}

static void parse_arp_reply4(unsigned char __far *packet)
{
  unsigned char __far *source_mac = packet;
  union ip_addr ip_address;

/*  ipv4_address.p1 = packet[6];
  ipv4_address.p2 = packet[7];
  ipv4_address.p3 = packet[8];
  ipv4_address.p4 = packet[9];  */
  _fmemcpy(&ip_address.ipv4_addr, &packet[6], 4);

  if(!_fmemcmp((void __far*)&ip_address.ipv4_addr, (void __far*)&ipv4_gateway, sizeof(struct ipv4_addr)))
  {
    if(!_fmemcmp(gateway_mac, broadcast_mac, 6)) // to prevent ARP spoofing
      _fmemcpy(gateway_mac, source_mac, 6);
    return;
  } 

  add_to_arp_cache4(ip_address, source_mac, 0);
}

static int address_in_arp_cache(union ip_addr *addr, char ipv6)
{
  unsigned long time = ttime(0);
  unsigned char addrlen = ipv6 ? 16 : 4;
  int index = ARP_CACHE_SIZE;

  while(index--)
  {
    if((arp_cache[index].type != ipv6) || (time > arp_cache[index].timestamp + ARP_ENTRY_TTL)) continue;
/*    if(arp_cache[index].ip_addr.ipv4_addr.p1 == addr.p1
    && arp_cache[index].ip_addr.ipv4_addr.p2 == addr.p2
    && arp_cache[index].ip_addr.ipv4_addr.p3 == addr.p3
    && arp_cache[index].ip_addr.ipv4_addr.p4 == addr.p4)*/
    if(!_fmemcmp(&arp_cache[index].ip_addr, addr, addrlen))
      break;
  }

  return index;
}

static int parse_arp(struct raw_packet __far packet)
{
  unsigned char __far *pckt_ptr = &packet.data[14];
  unsigned short __far *shortptr = (unsigned short __far*)&packet.data[14];

  if(switch_endianness_s(shortptr[0]) != 1)
  {
    return -1; // hardware type != ethernet
  }

  if(switch_endianness_s(shortptr[1]) != 0x0800)
  {
    return -2; // address type != ipv4
  }

  if(pckt_ptr[4] != 6)
  {
    return -3; // device address size != 6
  }

  if(pckt_ptr[5] != 4)
  {
    return -4; // logical address size != 4
  }

  switch(switch_endianness_s(shortptr[3])) // opcode
  {
    case 1: // request
      if(packet.length < 42) return -6;
      reply_arp4((unsigned char __far*)&shortptr[4]);
    return 0;
    case 2: // reply
      if(packet.length < 60) return -7;
      parse_arp_reply4((unsigned char __far*)&shortptr[4]);
    return 1;
  }
  return -5;
}

static void send_arp_request_ipv4(struct ipv4_addr addr)
{
  char packet[60];
  char *arpptr = &packet[14];
  unsigned short *shortptr = (void*)&packet[14];
  char *source_mac = &arpptr[8];
  char *source_ip = &arpptr[14];
  char *unknown_mac = &arpptr[18];
  char *unknown_ip = &arpptr[24];

  init_arp_header(packet, broadcast_mac);

  shortptr[0] = switch_endianness_s(1);
  shortptr[1] = switch_endianness_s(0x0800);
  arpptr[4] = 6;
  arpptr[5] = 4;
  shortptr[3] = switch_endianness_s(1);

  _fmemcpy(source_mac, my_mac, 6);
/*  source_ip[0] = ipv4_my_addr.p1;
  source_ip[1] = ipv4_my_addr.p2;
  source_ip[2] = ipv4_my_addr.p3;
  source_ip[3] = ipv4_my_addr.p4;  */
  _fmemcpy(source_ip, &ipv4_my_addr, 4);

  memset(unknown_mac, 0, 6);
/*  unknown_ip[0] = addr.p1;
  unknown_ip[1] = addr.p2;
  unknown_ip[2] = addr.p3;
  unknown_ip[3] = addr.p4;*/
  _fmemcpy(unknown_ip, &addr, 4);

  memset(&unknown_ip[4], 0, 18);

  send_raw_packet(packet, 60);  
}
