void __far *tsr_alloc_pragma(unsigned size);
#pragma aux tsr_alloc_pragma = \
  "add bx, 0xF" \
  "mov cl, 4" \
  "shr bx, cl" \
  "mov ah, 0x48" \
  "call cs:[call_dos]" \
  "jnc success" \
  "xor ax, ax" \
  "xor cx, cx" \
  "jmp fail" \
  "success:" \
  "mov cx, ax" \
  "xor ax, ax" \
  "fail:" \
  value [cx ax] parm [bx];

static void __far *tsr_alloc(unsigned size)
{
  return tsr_alloc_pragma(size);
}

#define tcpmalloc(size) tsr_alloc(size);

void tsr_free_pragma(unsigned segment);
#pragma aux tsr_free_pragma = \
  "push ax" \
  "mov ah, 0x49" \
  "call cs:[call_dos]" \
  "pop ax" \
  parm [es];

static void tsr_free(void __far *ptr)
{
  tsr_free_pragma(FP_SEG(ptr));
}

#define ffree(a) tsr_free(a)

static unsigned strtouint(char *str, char **endptr)
{
  unsigned retval = 0;
  unsigned mul;
  unsigned len = 0;
  unsigned add;

  while(*(str + len) >= '0' && *(str + len) <= '9')
    len++;

  while(len--)
  {
    mul = len;
    add = *str++ - '0';
    while(mul--) add *= 10;    
    retval += add;
  }
  *endptr = str;

  return retval;
}

static unsigned char strtohex(char *str)
{
  unsigned char retval = 0;

  if(*str <= 0x39)
    retval = *str;
  else
    retval = 0x09 + *str;

  str++;
  if(*str >= ' ' && *str != ':')
  {
    retval <<= 4;

    if(*str <= 0x39)
      retval |= *str & 0x0F;
    else
      retval |= (0x09 + *str) & 0x0F;
  }
  else retval &= 0xF;

  return retval;
}


unsigned int __based (__segname("_CODE")) DOSRAND_SEED;

static unsigned int tsr_rand(void)
{
  static unsigned __based(__segname("_CODE")) a;
  static unsigned __based(__segname("_CODE")) b;
  static unsigned __based(__segname("_CODE")) c;

  a++;
  b+=a+11;
  c-=b-19;

  return a+b+c + (DOSRAND_SEED = 23 * DOSRAND_SEED % 26479);
}

#define random() tsr_rand()

static unsigned long random32(void)
{
  return random() | ((unsigned long)random() << 16);
}

void wait_delay(unsigned seconds)
{
  unsigned long time = ttime(0);

  while(ttime(0) < time + seconds)
    service_packets();
}

static void tsr(void);
