
static int load_ip_setup(void)
{
  static char * /*__based(__segname("_CODE"))*/ settings[] =
  {
    "IPADDR", "BROADCAST", "NETMASK", "GATEWAY", "NAMESERVER", "MAC-GATEWAY",
    "DHCP", "MAC-MY", "MAC-6GATEWAY", "IP6LADDR", "IP6NAMESERVER", "IP6GADDR",
    "IP6-NETWORK-PREFIX"
  };
  char buff[80];
  unsigned p;
  unsigned n;
  struct ipv4_addr __based(__segname("_CODE")) *set;
  struct ipv6_addr __based(__segname("_CODE")) *set6;
  char *endptr;
  unsigned char dhcp_enabled = 0;
  unsigned char __based(__segname("_CODE")) * macptr;

  FILE *fp = fopen("setup.net", "rt");

  lease.user_dns = 0;

  if(!fp)
  {
    puts("Could not open setup file");
    return 1;
  }

  while(fgets(buff, 80, fp))
  {
    for(n=sizeof(settings)/sizeof(char*);n--;)
      if(!_fstrncmp(settings[n], buff, _fstrlen(settings[n])))
      {
        switch(n)
        {
          case 0:
            set = &ipv4_my_addr;
          break;
          case 1:
            set = &ipv4_broadcast;
          break;
          case 2:
            set = &ipv4_netmask;
          break;
          case 3:
            set = &ipv4_gateway;
          break;
          case 4:
            lease.user_dns = 1;
            set = &ipv4_dns;
          break;
          case 6:
            dhcp_enabled++;
          break;
        }
        if(n < 5)
        {
          set->p1 = strtouint((char *)strchr(buff, ' ') + 1, &endptr); // NOTE! Typecast from FAR to NEAR pointer, data segment must be automatically correct!
          set->p2 = strtouint(endptr+1, &endptr);
          set->p3 = strtouint(endptr+1, &endptr);
          set->p4 = strtouint(endptr+1, &endptr);
          printf("%s: %u.%u.%u.%u\n", settings[n], set->p1, set->p2, set->p3, set->p4);          
        }
        if(n == 5 || n == 7 || n == 8)
        {
          if(n == 5) macptr = gateway_mac;
          else if(n == 7) macptr = my_mac;
          else macptr = gateway6_mac;
          for(p=0,endptr=(char*)strchr(buff, ' ')+1;p<6;p++,endptr+=3)
            macptr[p] = strtohex(endptr);
          printf("%s: %.2X:%.2X:%.2X:%.2X:%.2X:%.2X\n", settings[n], macptr[0], macptr[1], macptr[2], macptr[3],
            macptr[4], macptr[5]);
        }
        if(n == 9 || n == 11) // IPv6 local-link address or global address
        {
          if(n == 9)
            set6 = &ipv6_local_addr;
          else
            set6 = &ipv6_global_addr;

          strtoipv6(set6, (char*)strchr(buff, ' ')+1);
          printf("%s: %.4X:%.4X:%.4X:%.4X:%.4X:%.4X:%.4X:%.4X\n", settings[n],
            switch_endianness_s(set6->p1),
            switch_endianness_s(set6->p2), 
            switch_endianness_s(set6->p3),
            switch_endianness_s(set6->p4), 
            switch_endianness_s(set6->p5),
            switch_endianness_s(set6->p6),
            switch_endianness_s(set6->p7),
            switch_endianness_s(set6->p8));
        }
        if(n == 10) // IPv6 nameserver
        {}
        if(n == 12) // IPv6 network prefix
        {
          ipv6_network_prefix = atoi((char*)strchr(buff, ' ')+1);
          printf("%s: %i\n", settings[n], ipv6_network_prefix);
        }
      }
  }
  fclose(fp);
  if(dhcp_enabled)
    lease.status = 3; // INIT
  else
  {
    lease.status = -1; // DISABLED
    lease6.status = -1;
  }
  return 0;
}
