static void init_packet_header(unsigned char __far *packet, void __far *dst_mac, char ipv6)
{
  static unsigned __based(__segname("_CODE")) ipv_packet_types[2] =
  {
    0x0008, 0xDD86
  };

  _fmemcpy((void __far*)packet, dst_mac, 6);
  _fmemcpy((void __far*)&packet[6], (void __far*)my_mac, 6);

  *(unsigned __far*)&packet[12] = ipv_packet_types[ipv6];
}

static void init_ipv6_packet_header(struct ipv6_addr dst, unsigned char __far *packet, unsigned char __far *dest_mac)
{
  int n;
  unsigned char mcast_mac[6];

  if(dest_mac)
  {
    init_packet_header(packet, dest_mac, 1);
  }
  else
    if(is_ipv6_multicast(&dst)) // multicast IPv6 address?
    {
      goto send2mcast;
    }
    else
      if(address_in_same_ipv6_subnet(&dst))
      {
        if(!_fmemcmp((void __far*)&dst, (void __far*)&ipv6_gateway, sizeof(struct ipv6_addr)))
          goto send2gateway;
        else if((n = address_in_arp_cache((union ip_addr*)&dst, 1)) >= 0)
          init_packet_header(packet, arp_cache[n].mac, 1);
        else
        {
          send_nd_sol(&dst, &dst, 135);
          send2mcast:
          ipv6_multicast_mac(&dst, mcast_mac);
          init_packet_header(packet, mcast_mac, 1);
        }
      }
      else
        send2gateway:init_packet_header(packet, gateway_mac, 1);
}

static void init_ipv4_packet_header(struct ipv4_addr dst, unsigned char __far *packet, char __far *dest_mac)
{
  int n;

  if(!_fmemcmp((void __far*)&dst, (void __far*)&ipv4_broadcast, sizeof(struct ipv4_addr)))
    init_packet_header(packet, broadcast_mac, 0);
  else
  {
    if(!dest_mac)
    {
      if(address_in_same_ipv4_subnet(dst))
      {
        if(!_fmemcmp((void __far*)&dst, (void __far*)&ipv4_gateway, sizeof(struct ipv4_addr)))
          goto send2gateway;
        else if((n = address_in_arp_cache((union ip_addr*)&dst, 0)) >= 0)
          init_packet_header(packet, arp_cache[n].mac, 0);
        else
        {
          send_arp_request_ipv4(dst);
          send2gateway:
          init_packet_header(packet, gateway_mac, 0);
        }
      }
      else goto send2gateway;
    }
    else
      init_packet_header(packet, dest_mac, 0);
  }
}


static unsigned get_free_port(unsigned udp, void __far *remote_addr, unsigned remote_port, unsigned ipv6)
{
  unsigned retval;

  do
    retval = tsr_rand();  
  while((ipv6 ? find_socket_by_ports_and_remote_addr6(retval, remote_port, *(struct ipv6_addr __far*)&remote_addr, udp)
        : find_socket_by_ports_and_remote_addr4(retval, remote_port, *(struct ipv4_addr __far *)&remote_addr, udp)) != -1);

  return retval;
}
