static unsigned find_raw_socket(unsigned type, void *addr, unsigned char protocol)
{
  int n = MAX_SOCKETS;

  while(n--)
  {
    if(sockets[n] && sockets[n]->raw == type)
      if(type == 3)
        break;
      else if(sockets[n]->ipv6 == (type & 1)
             && !_fmemcmp(&sockets[n]->ip_addr, addr,
             sockets[n]->ipv6 ? sizeof(struct ipv6_addr) : sizeof(struct ipv4_addr))
             && sockets[n]->raw_protocol == protocol)
        break;
  }
  return n;
}

static int raw_packetizer(unsigned socket, unsigned char __far *data, unsigned length)
{
  unsigned total_length;
  unsigned ip_header_length;
  struct ipv4_header ipv4_header;
  struct ipv6_header ipv6_header;
  unsigned char __far *packet;
  unsigned char __far *payload;

  if(sockets[socket]->raw == 3)
    return send_raw_packet(packet, length);

  packet = get_free_async_buff();
  payload = &packet[14];
  if(sockets[socket]->raw == 2)
  {
    init_ipv4_packet_header(sockets[socket]->ip_addr.ipv4_addr, packet, 0);  
    init_ipv4_header_struct(&ipv4_header, sockets[socket]->raw_protocol, sockets[socket]->ip_addr.ipv4_addr);
    ip_header_length = build_ipv4_header(payload, &ipv4_header);
    total_length = ip_header_length + length;
    _fmemcpy(&packet[14+ip_header_length], data, length);
    ipv4_inject_lengthinfo(payload, total_length);
    ipv4_inject_header_checksum(payload, ip_header_length);
    return send_ip_packet(packet, total_length+14);
  }
  else // if(sockets[socket]->raw == 1)
  {
    init_ipv6_packet_header(sockets[socket]->ip_addr.ipv6_addr, packet, 0);
    init_ipv6_header_struct(&ipv6_header, sockets[socket]->raw_protocol, sockets[socket]->ip_addr.ipv6_addr);
    build_ipv6_header(payload, &ipv6_header);
    total_length = 40 + length;
    _fmemcpy(&packet[14+40], data, length);
    ipv6_inject_lengthinfo(payload, length);
    return send_ip6_packet(packet, total_length+14);
  }
}

static void recv_raw_socket(unsigned socket, unsigned char __far *data, unsigned length)
{
  unsigned __far *write_offset = &sockets[socket]->in_buff_write_offset;

  if(length + 2 < socket_buffer_free(socket))
  {
    copy2ring(sockets[socket]->in_buff, (unsigned char __far*)&length, *write_offset, SOCKET_IN_BUFF_SIZE, sizeof(unsigned));
    *write_offset += sizeof(unsigned);
    copy2ring(sockets[socket]->in_buff, data, *write_offset, SOCKET_IN_BUFF_SIZE, length);
    *write_offset += length;
  }
}
