void save_stack();

#include "dosexec.c"

static void parse_cmd(char *cmd)
{
  char *whitespace = (char*)strchr(cmd, ' ');
  char *args;
  unsigned rc;

  if(whitespace)
  {
    args = whitespace+1;
    *whitespace = 0;
  }
  else args = cmd+strlen(cmd);
  rc = dosexec(cmd, args);
  if(rc)
    printf("Error code: %u\n", rc);
}

static void prompt(void)
{
  char command[256];
  while(1)
  {
    printf("ONLINE>");
    fflush(stdout);
    gets(command);
    if(!strcmp(command, "exit")) break;
    parse_cmd(command);
  }
}

struct args
{
  char *program_name;
  char args[128];
};

static void parse_args(int argc, char **argv)
{
  struct args args;
  unsigned n;

  args.program_name = argv[1];

  args.args[0] = 0;

  for(n=2;n<argc;n++)
  {
    strcat(args.args, argv[n]);
    strcat(args.args, " ");
  }

  dosexec(args.program_name, args.args);
}
