void __far *chrmem(void __far *buff, unsigned char byte, unsigned count);
#pragma aux chrmem value [es di] parm [es di] [ax] [cx];

#define memchr(buf, byte, count) chrmem(buf, byte, count)
#define _fmemchr(buf, byte, count) chrmem(buf, byte, count)

unsigned cmpmem(void __far *buf1, void __far *buf2, unsigned count);
#pragma aux cmpmem = \
  "push ds" \
  "mov ds, dx" \
  "cld" \
  "or cx, cx" \
  "repe cmpsb" \
  "jz equals" \
  "inc cx" \
  "equals:" \
  "pop ds" \
  value [cx] parm [es di] [dx si] [cx];
/*unsigned cmpmem(void __far *buf1, void __far *buf2, unsigned count)
{
  char __far *ptr1 = buf1;
  char __far *ptr2 = buf2;

  do
    if(*ptr1++ != *ptr2++)
      break;
  while(--count);

  return count;
}*/

#define memcmp(buf1, buf2, count) cmpmem(buf1, buf2, count)
#define _fmemcmp(buf1, buf2, count) cmpmem(buf1, buf2, count)

unsigned lenstr(char __far *str);
#pragma aux lenstr value [ax] parm [es di];

#define _fstrlen(str) lenstr(str)
#define strlen(str) lenstr(str)

static int cmpstr(char __far *str1, char __far *str2)
{
  register int c;
  unsigned len1 = _fstrlen(str1);
  unsigned len2 = _fstrlen(str2);
  if(!(c = len1 - len2))
  {
    return _fmemcmp(str2, str1, len1);
  }
  return c;
}

#define _fstrcmp(str1, str2) cmpstr(str1, str2)
#define strcmp(str1, str2) cmpstr(str1, str2)

#define chrstr(str, c) memchr(str, c, lenstr(str)+1)

#define _fstrchr(str, c) chrstr(str, c)
#define strchr(str, c) chrstr(str, c)

void __far *setmem(void __far *dst, unsigned value, unsigned bytecount);
#pragma aux setmem parm [es di] [ax] [cx] value [es di];

#define _fmemset(dst, value, bytecount) setmem(dst, value, bytecount)
#define memset(dst, value, bytecount) setmem(dst, value, bytecount)

void __far *copymem(void __far *dst, void __far *src, unsigned bytecount);
#pragma aux copymem parm [es di] [dx si] [cx] value [es di];

#define memcpy(dst, src, count) copymem(dst, src, count)
#define _fmemcpy(dst, src, count) copymem(dst, src, count)

#define strcpy(dst, src) copymem(dst, src, strlen(src)+1)
#define _fstrcpy(dst, src) _fmemcpy(dst, src, _fstrlen(src)+1)

static int cmpnstr(char __far *str1, char __far *str2, unsigned count)
{
  unsigned len1 = strlen(str1);
  unsigned len2 = strlen(str2);

  if(len1 < count) count = len1;
  if(len2 < count) count = len2;

  return _fmemcmp(str2, str1, count);
}

#define strncmp(str1, str2, count) cmpnstr(str1, str2, count)
#define _fstrncmp(str1, str2, count) cmpnstr(str1, str2, count)


static char __far *cpynstr(char __far *dst, char __far *src, unsigned count)
{
  unsigned str_len = strlen(src)+1;
  if(str_len > count)
    return memcpy(dst, src, count);
  else
    return memcpy(dst, src, str_len);
}

#define _fstrncpy(dst, src, count) cpynstr(dst, src, count)
#define strncpy(dst, src, count) cpynstr(dst, src, count)
