static struct incoming_packet parse_packet(struct raw_packet packet)
{
  struct incoming_packet retval;
  unsigned char __far *ip_header = &packet.data[14];
  unsigned header_length;
  unsigned total_length;
  unsigned payload_len;
  unsigned char __far *payload_protocol;
  unsigned char ipversion;
  unsigned s;

  if((s = find_raw_socket(3, 0, 0)) != -1)
    recv_raw_socket(s, packet.data, packet.length);

  if(packet.length < 14)
  {
    retval.error = -4;
    return retval; // packet's length is less than normal ethernet header
  }

  #ifndef NOPROMISCUOUS
  if(_fmemcmp(packet.data, (void __far*)my_mac, 6)
//     && _fmemcmp(packet.data, (void __far*)broadcast_mac, 6))
     && !(packet.data[0] & 0x01)) // multicast bit not set
  {
    goto error1;
  }
  #endif

  if(packet.data[12] != 0x08 && packet.data[12] != 0x86)
  {
    retval.error = -2;
    return retval; // not an IP packet or an ARP packet
  }

  memset(&retval, 0, sizeof(struct incoming_packet));  

  if(packet.data[13] == 0x06) // this is an ARP packet
  {
    parse_arp(packet);
    return retval;
  }

/*  if(packet.data[13])
  {
    retval.error = -7;
    return retval; // not an ipv4 or an ARP packet
  }*/

  ipversion = ip_header[0] >> 4;
  if(ipversion != 4 && ipversion != 6)
  {
    retval.error = -3;
    return retval; // not an ipv4 or ipv6 packet
  }

  _fmemcpy(retval.sender_mac, &packet.data[6], 6);

  if(ipversion == 4)
    header_length = (ip_header[0] & 0x0F) << 2;
  else
  {
    header_length = 40;
    retval.ipv6 = 1;
  }

  if(packet.length - 14 < header_length)
  {
    retval.error = -5;
    return retval; // packet length is less than header says
  }

  if(ipversion == 4)
  {
    retval.ip_header.ipv4_header.type_of_service = ip_header[1];
    total_length = *(unsigned short __far*)&ip_header[2];
  }
  else
    total_length = *(unsigned short __far*)&ip_header[4];

  total_length = switch_endianness_s(total_length);

  if(packet.length - 14 < total_length)
  {
    retval.error = -6;
    return retval; // packet length is less than total length in header
  }

  if(ipversion == 4)
  {
    _fmemcpy(&retval.ip_header.ipv4_header.src_address, &ip_header[12], 4);

    _fmemcpy(&retval.ip_header.ipv4_header.dst_address, &ip_header[16], 4);

    if(packet.data != loopback.packet.data)
    {
      if(ipv4_header_checksum(ip_header, header_length))
      {
        retval.error = -7;
        return retval;
      }

      if(retval.ip_header.ipv4_header.src_address.p1 == 127)
      { // drop incoming packets that are "from localhost"
        error9:
        retval.error = -9;
        return retval;
      }
      if(lease.status <= 0)
        if(_fmemcmp(&retval.ip_header.ipv4_header.dst_address, &ipv4_my_addr, sizeof(struct ipv4_addr))
           && _fmemcmp(&retval.ip_header.ipv4_header.dst_address, &ipv4_broadcast, sizeof(struct ipv4_addr)))
      {
        error1: // this computer is not the destination
        rx_dropped_packets++;
        retval.error = -1;
        return retval;
      }
    }

    payload_protocol = &ip_header[header_length];
    payload_len = total_length - header_length;

    if((s = find_raw_socket(2, &retval.ip_header.ipv4_header.src_address, ip_header[9])) != -1)
      recv_raw_socket(s, payload_protocol, payload_len);

    switch(ip_header[9])
    {
      case 1:
        parse_icmp(payload_protocol, &retval.payload_header.icmp_header, &retval.data.icmp_echo, payload_len);
        retval.error = 1;
        break;
      case 6:
        parse_tcp4(payload_protocol, &retval.payload_header.tcp4_header, &retval.data.tcp4_data, payload_len, (union ip_addr*)&retval.ip_header.ipv4_header.src_address, retval.sender_mac, 0);
        break;
      case 17:
        parse_udp4(payload_protocol, &retval.payload_header.udp4_header, payload_len, (union ip_addr*)&retval.ip_header.ipv4_header.src_address, (union ip_addr*)&retval.ip_header.ipv4_header.dst_address, retval.sender_mac, 0);
        break;
    }
  }
  else // IPv6
  {
    payload_protocol = &ip_header[40];
    payload_len = switch_endianness_s(*(unsigned short __far*)&ip_header[4]);
    if(payload_len > packet.length-40-14)
    {
      retval.error = -10;
      return retval;
    }

    _fmemcpy(&retval.ip_header.ipv6_header.src_address, &ip_header[8], 16);
    _fmemcpy(&retval.ip_header.ipv6_header.dst_address, &ip_header[24], 16);

    if(packet.data != loopback.packet.data)
    {
      if(is_localhost6(&retval.ip_header.ipv6_header.src_address))
      {
        goto error9;
      }
      if(lease6.status <= 0)
      {
        if(ipv6_point_my_addr(&retval.ip_header.ipv6_header.dst_address))
          goto error1;
      }
    }

    if((s = find_raw_socket(1, &retval.ip_header.ipv6_header.src_address, ip_header[6])) != -1)
      recv_raw_socket(s, payload_protocol, payload_len);
    
    switch(ip_header[6])
    {
      case 58:
        if(2 == parse_icmp6(payload_protocol, &retval.payload_header.icmp6_header, &retval.data.icmp_echo, payload_len, &retval.ip_header.ipv6_header.dst_address, &retval.ip_header.ipv6_header.src_address, retval.sender_mac))
          retval.error = 2;
        break;
      case 17:
        parse_udp4(payload_protocol, &retval.payload_header.udp4_header, payload_len, (union ip_addr*)&retval.ip_header.ipv6_header.src_address, (union ip_addr*)&retval.ip_header.ipv6_header.dst_address, retval.sender_mac, 1);
        break;
      case 6:
        parse_tcp4(payload_protocol, &retval.payload_header.tcp4_header, &retval.data.tcp4_data, payload_len, (union ip_addr*)&retval.ip_header.ipv6_header.src_address, retval.sender_mac, 1);
        break;
    }
  }
 
  return retval;
}

static void parse_incoming_packet(unsigned packet)
{
  struct incoming_packet incoming_packet = parse_packet(raw_packet[packet]);
  unsigned new_startindex;

  if(incoming_packet.error == 1)
  {
    // respond to ping...
    if(is_icmp_echo_request(incoming_packet.payload_header.icmp_header))
      pingpong:if(raw_packet[packet].length <= OUT_PACKET_SIZE)
        respond_ping(&incoming_packet);
  }
  else if(incoming_packet.error == 2)
    goto pingpong;
  else if(incoming_packet.error < -1)
    rx_error_count++;

// disable(); // shouldn't be needed...
  new_startindex = raw_packet_startindex;
  new_startindex += raw_packet[packet].length;
  new_startindex &= RAW_PACKET_BUFFER_MAX;
  raw_packet_startindex = new_startindex;
  raw_packet[packet].data = 0;
//  enable();
}

static void parse_loopback(void)
{
  loopback.processing = 1;
  loopback.has_data = 0;
  parse_packet(loopback.packet);
}
