#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#include "socket.h"

unsigned call_tcp_stack(unsigned function);
#pragma aux call_tcp_stack = \
  "int 0x61" \
  parm [ax] value [ax];

int main()
{
  unsigned long l;
  int s;
  struct sockaddr_in sockaddr;
  struct sockaddr_in6 sockaddr6;
  unsigned n = sizeof(sockaddr);
  int r;
  char nomemerr[] = "Not enough resources to create new socket";

  if(!_dos_getvect(0x61))
  {
    puts("TCP/IP stack is not loaded.");
    return 1;
  }

  s = socket(AF_INET, SOCK_DGRAM, 0);
  if(s != -1)
  {
    r = getsockname(s, &sockaddr, &n);
    close_socket(s);
    if(r == -1)
      puts("Could not get my IPv4 address!");
    printf("IPv4 address: ");
    printf("%u.", ((unsigned char*)&sockaddr.sin_addr.s_addr)[0]);
    printf("%u.", ((unsigned char*)&sockaddr.sin_addr.s_addr)[1]);
    printf("%u.", ((unsigned char*)&sockaddr.sin_addr.s_addr)[2]);
    printf("%u\n", ((unsigned char*)&sockaddr.sin_addr.s_addr)[3]);
  }
  else puts(nomemerr);

  for(l=0;l<2;l++)
  {
    s = socket(AF_INET6, SOCK_DGRAM, 0);
    if(s != -1)
    {
      n = sizeof(sockaddr6);
      if(!l)
      {
        sockaddr6.sin6_family = AF_INET6;
        sockaddr6.sin6_addr.s6_addr[0] = 0xfe;
        sockaddr6.sin6_addr.s6_addr[1] = 0x80;
        memset(&sockaddr6.sin6_addr.s6_addr[2], 0, 14);
      }
      else
      {
        memset(&sockaddr6.sin6_addr.s6_addr, -1, 16);
      }
      
      connect(s, &sockaddr6, sizeof(sockaddr6));

      r = getsockname(s, &sockaddr6, &n);
      close_socket(s);
      if(r == -1)
        puts("Could not get my IPv6 address!");
      printf("IPv6 address: ");
      for(n=0;n<16;n++)
      {
        printf("%.2x", sockaddr6.sin6_addr.s6_addr[n]);
        if(n & 1)
          if(n != 15) putchar(':');
          else putchar('\n');
      }
    }
    else puts(nomemerr);
  }

  printf("active sockets: %u\n", call_tcp_stack(13));
  printf("rx errors: %u\n", call_tcp_stack(14));
  printf("tx errors: %u\n", call_tcp_stack(15));
  printf("dropped rx packets: %u\n", call_tcp_stack(16));
  printf("dropped tx packets: %u\n", call_tcp_stack(17));
  printf("rx packets: %u\n", call_tcp_stack(18));
  printf("tx packets: %u\n", call_tcp_stack(19));

  l = call_tcp_stack(20) | ((unsigned long)call_tcp_stack(21) << 16);
  printf("rx bytes: %lu\n", l);
  l = call_tcp_stack(22) | ((unsigned long)call_tcp_stack(23) << 16);
  printf("tx bytes: %lu\n", l);

  return 0;
}
