.8086

.MODEL small


PUBLIC tcp_service_
PUBLIC go_tsr_
PUBLIC save_psp_
PUBLIC set_vector_
PUBLIC receiver_wrapper_
PUBLIC timer_int_
PUBLIC _old_timer_handler
PUBLIC oom_int_
PUBLIC _old_oom_int
PUBLIC _timer_var
PUBLIC _int21_handler
PUBLIC int13h_wrp_
PUBLIC _int13_handler
PUBLIC _bios_dmaio_in_progress
PUBLIC _clock_ticks
PUBLIC pit_counter_
PUBLIC _call_dos
EXTERN defrag_memory_:BYTE
EXTERN receiver_:BYTE
EXTERN service_packets_:BYTE
EXTERN connect_:BYTE
EXTERN socket_read_:BYTE
EXTERN socket_write_:BYTE
EXTERN close_socket_:BYTE
EXTERN puts_:byte
EXTERN open_port_:BYTE
;EXTERN close_port_:BYTE
EXTERN get_error_code_:BYTE
EXTERN socket_exists_:BYTE
EXTERN socket_status_:BYTE
EXTERN new_socket_:BYTE
EXTERN bind_socket_:BYTE
EXTERN connect_socket_:BYTE
EXTERN getpeername_:BYTE
EXTERN getsockname_:BYTE
EXTERN setpeername_:BYTE
EXTERN socket_count_:BYTE
EXTERN transmit_block_:BYTE
EXTERN end_tcp_stack_:BYTE
EXTERN listen_socket_:BYTE

EXTERN _stack_seg:WORD
;EXTERN _stack_ptr:WORD
;EXTERN _base_ptr:WORD
EXTERN _old_stack_seg:WORD
EXTERN _old_stack_ptr:WORD
EXTERN _receiver_old_stack_seg:WORD
EXTERN _receiver_old_stack_ptr:WORD
;EXTERN _old_base_ptr:WORD
EXTERN _data_seg:WORD
EXTERN _this_psp:WORD
EXTERN _user_psp:WORD
EXTERN _rx_error_count:WORD
EXTERN _tx_error_count:WORD
EXTERN _rx_dropped_packets:WORD
EXTERN _tx_dropped_packets:WORD
EXTERN _rx_packets:WORD
EXTERN _tx_packets:WORD
EXTERN _tx_bytes:DWORD
EXTERN _rx_bytes:DWORD

_TEXT               SEGMENT BYTE PUBLIC USE16 'CODE'
                ASSUME CS:_TEXT                               

doscall_sp: dw 0
_oom_psp: dw 0

_call_dos: dw offset call_dos_notsr

call_dos_notsr proc near
  int 0x21
  ret
call_dos_notsr endp

call_dos_tsr proc near
  mov cs:doscall_sp, sp
  mov ss, cs:_old_stack_seg
  mov sp, cs:_old_stack_ptr
  int 0x21
  mov ss, cs:_stack_seg
  mov sp, cs:doscall_sp
  ret
call_dos_tsr endp

tcp_service_ proc near
  ; set stack 
  mov cs:_old_stack_seg, ss
  mov cs:_old_stack_ptr, sp
  mov ss, cs:_stack_seg
  mov sp, 2048
  sti

  ; set current PSP for the kernel
  push bx
  push ax
  mov ah, 0x51
  call cs:[_call_dos]
  mov cs:_user_psp, bx
  mov ah, 0x50
  mov bx, cs:_this_psp
  call cs:[_call_dos]
  pop ax
  pop bx

  push bx
IFDEF __386__
.386
  push ecx
ELSE
  push cx
ENDIF
  push dx
  push es
  push si
  push di
  push ds
  push bp  

  cmp ax, 1
  je connect
  push ss
  pop ds
  cmp ax, 0
  je service_packets
  cmp ax, 2
  je socket_read
  cmp ax, 3
  je socket_write
  cmp ax, 4
  je socket_close
  cmp ax, 5
  je open_port
  cmp ax, 6
  je get_error
  cmp ax, 7
  je socket_exist
  cmp ax, 8
  je get_socket_status
  cmp ax, 9
  je new_socket
  cmp ax, 10
  je bind
  cmp ax, 11
  je connect_bsd
  cmp ax, 12
  je getpeername
  cmp ax, 13
  je getsocketcount
  cmp ax, 14
  je getrxerrors
  cmp ax, 15
  je gettxerrors
  cmp ax, 16
  je getrxdroppedpackets
  cmp ax, 17
  je gettxdroppedpackets
  cmp ax, 18
  je getrxpackets
  cmp ax, 19
  je gettxpackets
  cmp ax, 20
  je getrxbytes_low
  cmp ax, 21
  je getrxbytes_high
  cmp ax, 22
  je gettxbytes_low
  cmp ax, 23
  je gettxbytes_high
  cmp ax, 24
  je getblockinfo
  cmp ax, 25
  je set_idle_int
  cmp ax, 26
  je reset_idle_int
  cmp ax, 27
  je listen
  cmp ax, 28
  je getsockname
  cmp ax, 29
  je setpeername
  cmp ax, 0xFF
  je unload_tsr
  jmp serv_end
  
  service_packets:
    call near ptr service_packets_
  jmp serv_end
  
  connect:        

    mov dx, cx
    mov cx, 128
    sub sp, cx

    mov di, sp
    mov ax, ss
    mov es, ax
    cld
    rep movsb  

    mov cx, dx
    mov dx, sp
    
    push ss
    pop ds

    call near ptr connect_      
    
    add sp, 128
    
  jmp serv_end
  
  socket_read:
    call near ptr socket_read_    
  jmp serv_end
  
  socket_write:
    call near ptr socket_write_    
  jmp serv_end
  
  socket_close:
    call near ptr close_socket_    
  jmp serv_end
  
  open_port:
    call near ptr open_port_
  jmp serv_end
  
  get_error:
    call near ptr get_error_code_
  jmp serv_end
  
  socket_exist:
    call near ptr socket_exists_
  jmp serv_end

  get_socket_status:
    call near ptr socket_status_
  jmp serv_end

  new_socket:
    call near ptr new_socket_
  jmp serv_end

  bind:
    call near ptr bind_socket_
  jmp serv_end

  connect_bsd:
    call near ptr connect_socket_
  jmp serv_end

  getpeername:
    call near ptr getpeername_
  jmp serv_end

  getsockname:
    call near ptr getsockname_
  jmp serv_end

  setpeername:
    call near ptr setpeername_
  jmp serv_end

  getsocketcount:
    call near ptr socket_count_
  jmp serv_end

  getrxerrors:
    mov ax, cs:_rx_error_count
  jmp serv_end

  gettxerrors:
    mov ax, cs:_tx_error_count
  jmp serv_end

  getrxdroppedpackets:
    mov ax, cs:_rx_dropped_packets
  jmp serv_end

  gettxdroppedpackets:
    mov ax, cs:_tx_dropped_packets
  jmp serv_end

  getrxpackets:
    mov ax, cs:_rx_packets
  jmp serv_end

  gettxpackets:
    mov ax, cs:_tx_packets
  jmp serv_end

  getrxbytes_low:
    mov ax, word ptr cs:_rx_bytes
  jmp serv_end
  getrxbytes_high:
    mov ax, word ptr cs:_rx_bytes+2
  jmp serv_end

  gettxbytes_low:
    mov ax, word ptr cs:_tx_bytes
  jmp serv_end
  gettxbytes_high:
    mov ax, word ptr cs:_tx_bytes+2
  jmp serv_end

  getblockinfo:
    call near ptr transmit_block_
  jmp serv_end

  listen:
    call near ptr listen_socket_
  jmp serv_end

  serv_end:
  ; restore user PSP
  push ax
  mov ah, 0x50
  mov bx, cs:_user_psp
  call cs:[_call_dos]
  pop ax

  serv_restore_regs:
  ; restore registers
  pop bp  
  pop ds
  pop di
  pop si
  pop es
  pop dx
IFDEF __386__
  pop ecx
ELSE
  pop cx
ENDIF
  pop bx

  mov ss, cs:_old_stack_seg
  mov sp, cs:_old_stack_ptr

  iret
tcp_service_ endp

save_psp_ proc near
  push ax
  push bx
  mov ah, 0x51
  int 0x21
  mov cs:_this_psp, bx
  pop bx
  pop ax
  ret
save_psp_ endp

go_tsr_ proc near
  push ax

  mov cs:_call_dos, offset call_dos_tsr

  ; close files
  mov bx, -1
  close_files_loop:
  inc bx
  mov ah, 0x3E
  int 0x21
  jnc close_files_loop

  ; free environment
  mov es, cs:_this_psp
  mov es, es:[0x2C]
  mov ah, 0x49
  int 0x21

  pop ax
  ; go tsr
  mov ah, 0x31
  int 0x21
go_tsr_ endp

unload_tsr:
  call near ptr end_tcp_stack_

  ; restore user PSP
  mov ah, 0x50
  mov bx, cs:_user_psp
  int 0x21

  ; restore registers
  pop bp  
  pop ds
  pop di
  pop si
  pop es
  pop dx
  pop cx
  pop bx
  
  mov ss, cs:_old_stack_seg
  mov sp, cs:_old_stack_ptr

  mov es, cs:_this_psp
  mov ah, 0x49
;  cli
;  int 0x21
;  ret
  db 0xEA
  _int21_handler: dd 0

; AX = vector, CX:DX = pointer to function
set_vector_ proc near
  push ds
  mov ah, 0x25
  mov ds, cx
  int 0x21
  pop ds
  ret
set_vector_ endp

receiver_flag: db 0

; the packet driver SHOULD save all registers before calling receiver(),
; but for some reason many packet drivers don`t save them.
receiver_wrapper_ proc far
  pushf
  ; also the specification does not say that it is forbidden to call
  ; the receiver() function after EOI or with interrupts enabled, so
  ; just in case...
  test cs:receiver_flag, 0xFF
  jnz receiver_busy
  inc cs:receiver_flag

  mov cs:_receiver_old_stack_seg, ss
  mov cs:_receiver_old_stack_ptr, sp
  mov ss, cs:_stack_seg
  mov sp, 0x100
  push ds
  push ss
  pop ds


  call near ptr receiver_

  pop ds
  mov ss, cs:_receiver_old_stack_seg
  mov sp, cs:_receiver_old_stack_ptr

  dec cs:receiver_flag
  receiver_end:
  popf
  retf

  receiver_busy:
  xor di, di
  mov es, di
  jmp receiver_end
receiver_wrapper_ endp

dos_idle_int_ proc near
  push ax
  xor ax, ax
  int 0x61
  pop ax

  db 0xEA
  _old_idle_handler: dd 0x00000000
dos_idle_int_ endp

pit_counter_ proc near
  cli

  xor al, al
  out 0x43, al

  in al, 0x40
  mov ah, al
  in al, 0x40
  xchg ah, al

  not ax
  inc ax

  sti
  ret
pit_counter_ endp

_timer_var: dw 18
_clock_ticks: dw 0

timer_int_ proc near
  inc cs:_timer_var
  inc cs:_clock_ticks
  
  db 0xEA
  _old_timer_handler: dd 0x00000000
timer_int_ endp

oom_int_ proc near
  test byte ptr cs:_bios_dmaio_in_progress, 0xFF
  jnz oom_hdlr_jmp

  push ax
  push bx
  push ds
  push es

  push ss
  pop ds

  ; set current PSP for the kernel
  mov ah, 0x51
  int 0x21
  mov cs:_oom_psp, bx
  mov ah, 0x50
  mov bx, cs:_this_psp
  int 0x21

  mov cs:_call_dos, offset call_dos_notsr
  call near ptr defrag_memory_
  mov cs:_call_dos, offset call_dos_tsr

  ; restore user PSP
  mov ah, 0x50
  mov bx, cs:_oom_psp
  int 0x21

  oom_hdlr_end:
  pop es
  pop ds
  pop bx
  pop ax
  oom_hdlr_jmp:
  db 0xEA
  _old_oom_int: dd 0
oom_int_ endp

idle_int_set: db 0

set_idle_int proc near
  push ax
  push dx
  push ds

  test cs:idle_int_set, 0xFF
  jnz reset_idle_end
  mov cs:idle_int_set, 1

  push es
  push bx

  mov ax, 0x3528
  call cs:[_call_dos]

  mov word ptr cs:_old_idle_handler, bx
  mov word ptr cs:_old_idle_handler+2, es

  mov ax, 0x3513
  call cs:[_call_dos]
  mov word ptr cs:_int13_handler, bx
  mov word ptr cs:_int13_handler+2, es

  pop bx
  pop es

  mov ax, cs
  mov ds, ax
  mov ax, 0x2528
  mov dx, offset dos_idle_int_
  call cs:[_call_dos]

  mov ax, 0x2513
  mov dx, offset int13h_wrp_
  call cs:[_call_dos]

  jmp reset_idle_end
set_idle_int endp

reset_idle_int proc near
  push ax
  push dx
  push ds

  test cs:idle_int_set, 0xFF
  jz reset_idle_end
  mov cs:idle_int_set, 0

  lds dx, cs:_old_idle_handler
  mov ax, 0x2528
  call cs:[_call_dos]

  lds dx, cs:_int13_handler
  mov ax, 0x2513
  call cs:[_call_dos]

  reset_idle_end:
  pop ds
  pop dx
  pop ax
  jmp serv_end
reset_idle_int endp

_bios_dmaio_in_progress: db 0

int13h_wrp_ proc far
  push word ptr cs:_bios_dmaio_in_progress
  mov cs:_bios_dmaio_in_progress, 1

  pushf
  db 0x9A
  _int13_handler: dd 0

  pop word ptr cs:_bios_dmaio_in_progress

  retf 2
int13h_wrp_ endp

_TEXT ENDS

END


