static unsigned verify_icmp6_checksum(unsigned char __far *packet,
                  unsigned packet_len, struct ipv6_addr *src_addr,
                  struct ipv6_addr *dst_addr)
{
  return udp4_checksum(packet, ipv6_pseudoheader(*src_addr, *dst_addr, packet_len, 58), packet_len, 20);
}

static int parse_icmp6(unsigned char __far *packet, struct icmp6_header *header,
                       struct icmp_echo *icmp_data, unsigned packet_len,
                       struct ipv6_addr *dst_addr, struct ipv6_addr *src_addr,
                       unsigned char __far *sender_mac)
{
  struct nd_struct nd_struct;

  if(packet_len < 4) return -1;

  header->type = packet[0];
  header->code = packet[1];
  header->checksum = *(unsigned __far*)&packet[2];

  if(verify_icmp6_checksum(packet, packet_len, src_addr, dst_addr))
    return -1;

  if(header->type == 128)
  {
    parse_icmp(packet, (struct icmp_header *)header, icmp_data, packet_len);
    return 2;
  }

  if(header->type == 134) // router advertisement
  {
    parse_rt_ad(sender_mac, packet, packet_len);
    return 0;
  }
  if(header->type == 135) // neighbor solicitation
  {
    if(!parse_nd_sol(packet, packet_len, &nd_struct))
      return answer_nd_sol(src_addr, &nd_struct);
    return 0;
  }
  if(header->type == 136) // neighbor advertisement
  {
    parse_nd_ad(packet, packet_len, sender_mac);
    return 0;
  }

  return -1;
}

static int send_icmp6(struct ipv6_addr dst, unsigned char __far *icmp_packet, unsigned len, unsigned char __far *target_mac)
{
  unsigned far __far *checksum = (unsigned __far *)&icmp_packet[2];
  unsigned char __far *packet;
  unsigned char __far *payload;
  struct ipv6_header ipv6_header;

  *checksum = udp4_checksum(icmp_packet,
    ipv6_pseudoheader(*choose_local_address(&dst), dst, len, 58), len, 20);

  packet = get_free_async_buff();

  payload = &packet[14];

  init_ipv6_packet_header(dst, packet, target_mac);

  ipv6_header.time_to_live = 0xFF;
  ipv6_header.protocol = 58;

  ipv6_header.src_address = *choose_local_address(&dst);
  ipv6_header.dst_address = dst;

  build_ipv6_header(payload, &ipv6_header);

  ipv6_inject_lengthinfo(payload, len);

  _fmemcpy(&payload[40], icmp_packet, len);

  return send_ip6_packet(packet, len+14+40);
}

void send_pong6(struct ipv6_addr *dst, struct icmp6_header *icmp_header, struct icmp_echo *icmp_echo)
{
  icmp_echo->data[-8] = icmp_header->type;
  *(unsigned __far*)&icmp_echo->data[-6] = 0;
  send_icmp6(*dst, icmp_echo->data-8, icmp_echo->data_len+8, 0);
}
