static void get_dhcp_server_multicast(struct ipv6_addr *target)
{
  memset(target, 0, sizeof(struct ipv6_addr));
  target->p1 = 0x02FF;
  target->p7 = 0x0100;
  target->p8 = 0x0200;
}

static int dhcp6_request_addr(char __far *option_ia,
                         unsigned option_ia_len, char __far *option_server_id,
                         unsigned option_server_id_len);

static int parse_dhcp6_reply(unsigned char __far *packet, unsigned packet_len, 
                      struct ipv6_addr *src_addr)
{
  unsigned long transaction_id = (*(unsigned long __far*)&packet[0]) & 0xFFFFFF00;
  unsigned n;
  unsigned option_type;
  unsigned option_len;
  unsigned long time;
  unsigned address_option;

  unsigned char __far *server_identifier;
  unsigned server_identifier_len = 0;
  unsigned char __far *ia_address;
  unsigned ia_address_len = 0;

  if(transaction_id != lease6.transaction_id) return 1;

  if(lease6.status == 1 && packet[0] == 2 // advertise
     || lease6.status == 2 && packet[0] == 7) // reply
  {
    for(n=4;n<packet_len;)
    {
      option_type = switch_endianness_s(*(unsigned short __far*)&packet[n]);
      option_len = switch_endianness_s(*(unsigned short __far*)&packet[n+2]);
      if(option_len + n > packet_len) return 1;
      
      if(option_type == 2) // server identifier
      {
        server_identifier = &packet[n+4];
        server_identifier_len = option_len;
        if(packet[0] == 7)
        {
          lease6.server_identifier_len = server_identifier_len;
          _fmemcpy(lease6.server_identifier, server_identifier, server_identifier_len);
        }
      }
      else if(option_type == 3) // non-temporary address
      {
        address_option = switch_endianness_s(*(unsigned short __far*)&packet[n+16]);
        if(address_option == 13) // status code
        {
          if(*(unsigned short __far*)&packet[n+20] == 0x0300) // NoBinding
          {
            ia_address_len = 0;
            goto request_addr;
          }
        }
        if(address_option == 5) // ipv6 address
        {
          if(packet[0] == 7)
          {
            time = ttime(0);
            lease6.lease_end_time = time + switch_endianness_l(*(unsigned long __far*)&packet[n+8]);
            if(lease6.lease_end_time == time)
              lease6.lease_end_time = 3600;
                       
            _fmemcpy(&ipv6_global_addr, &packet[n+20], 16); 
            create_multicast_address(&ipv6_global_addr, &ipv6_global_multicast);
//            _fmemcpy(lease6.identity_association, &packet[n+4], 40);
            lease6.server_addr = *src_addr;
            lease6.status = 0;
          }
          else
          {
            lease6.status = 2;
            ia_address = &packet[n+4];
            ia_address_len = option_len;
          }
        }
      }
      n += option_len+4;
    }
  }

  if(server_identifier_len && ia_address_len)
  {
    request_addr:
    dhcp6_request_addr(/*src_addr, */ia_address, ia_address_len,
                  server_identifier, server_identifier_len);
  }

  return 0;
}

static unsigned char *dhcp6_add_option(unsigned option, unsigned length,
                                 unsigned char __far *data, unsigned char *target)
{
  *(unsigned *)&target[0] = switch_endianness_s(option);
  *(unsigned *)&target[2] = switch_endianness_s(length);
  _fmemcpy(&target[4], data, length);

  return target + length + 4;
}

static unsigned char *dhcp6_add_client_identifier(unsigned char *target)
{
  unsigned char data[14];

  *(unsigned *)&data[0] = 0x0100; // duid type: link-layer address + time
  *(unsigned *)&data[2] = switch_endianness_s(hardware_type);
  *(unsigned long*)&data[4] = switch_endianness_l(lease6.start_time);
  _fmemcpy(&data[8], my_mac, 6);

  return dhcp6_add_option(1, 14, data, target);
}

static unsigned char *dhcp6_add_server_identifier(unsigned char *target)
{
  return dhcp6_add_option(2, lease6.server_identifier_len,
                          lease6.server_identifier, target);
}

static void lease6_update_elapsed_time(void)
{
  lease6.time_elapsed = ttime(0) - lease6.request_time;
}

static unsigned char *dhcp6_add_elapsed_time(unsigned char *target)
{
  target[1] = 8; // elapsed time
  target[3] = 2; // length
  *(unsigned*)&target[4] = switch_endianness_s(lease6.time_elapsed);
  // elapsed time = 16 bit word to offset 32...
  return target+6;
}

static unsigned char *dhcp6_add_iaid(unsigned char *target)
{
  unsigned char buff[40];

  memset(buff, 0, sizeof(buff));

  *(unsigned long*)&buff[0] = lease6.iaid;

  buff[13] = 5; // option: address
  buff[15] = 24; // option length (containing lifetime values)

  _fmemcpy(&buff[16], &ipv6_global_addr, sizeof(struct ipv6_addr));

  return dhcp6_add_option(3, sizeof(buff), buff, target);

//  return dhcp6_add_option(3, 40, lease6.identity_association, target);
}

static int dhcp6_request_addr(char __far *option_ia,
                         unsigned option_ia_len, char __far *option_server_id,
                         unsigned option_server_id_len)
{
  struct udp_data data;
  struct udp4_header header;
  unsigned char dhcp_packet[300];
  unsigned char *ptr;
  unsigned ol;
  struct ipv6_addr dhcp_server_addr;

  get_dhcp_server_multicast(&dhcp_server_addr);

  header.src_port = 546;
  header.dst_port = 547;

  memset(dhcp_packet, 0, sizeof(dhcp_packet));

  *(unsigned long *)&dhcp_packet[0] = lease6.transaction_id;
  dhcp_packet[0] = 3; // confirm

  lease6_update_elapsed_time();

  ptr = &dhcp_packet[4];

  ptr = dhcp6_add_client_identifier(ptr);

  ptr = dhcp6_add_elapsed_time(ptr);

  if(option_ia_len)
    ptr = dhcp6_add_option(3, option_ia_len, option_ia, ptr);
  else
    ptr = dhcp6_add_iaid(ptr);

  ptr = dhcp6_add_option(2, option_server_id_len, option_server_id, ptr);

  data.data = dhcp_packet;
  data.len = ptr - dhcp_packet;

  return send_udp6(dhcp_server_addr, &header, &data);
}

static int renew_dhcp6(void)
{
  struct udp_data data;
  struct udp4_header header;
  unsigned char dhcp_packet[300];
  unsigned char *ptr;
  struct ipv6_addr dhcp_server_addr;

  get_dhcp_server_multicast(&dhcp_server_addr);

  lease6_update_elapsed_time();

  header.src_port = 546;
  header.dst_port = 547;

  memset(dhcp_packet, 0, sizeof(dhcp_packet));

  data.data = dhcp_packet;

  *(unsigned long*)&dhcp_packet[0] = lease6.transaction_id;
  dhcp_packet[0] = 5; // message type = renew

  ptr = &dhcp_packet[4];

  ptr = dhcp6_add_client_identifier(ptr);
  ptr = dhcp6_add_server_identifier(ptr);
  ptr = dhcp6_add_elapsed_time(ptr);
  ptr = dhcp6_add_iaid(ptr);

  data.len = ptr - dhcp_packet;

  lease6.status = 2;

  return send_udp6(dhcp_server_addr, &header, &data);
}

static int get_stateless_ipv6_address(struct ipv6_addr __far *taddr, unsigned char prefix)
{
  char retries = 5;
  struct ipv6_addr __far *multicast;
  unsigned char n;

  while(retries--)
  {
    // TODO...
    for(n=prefix+7;n<128;n+=8)
      ((unsigned char __far*)&ipv6_tentative_address)[n>>3] = random();

    if(ipv6_tentative_address.p1 == 0x80fe)
      multicast = &nd6_multicast;
    else
      multicast = &ipv6_global_multicast;
    create_multicast_address(&ipv6_tentative_address, multicast);

    puts("Sending ND solicitation for IPv6 tentative address...");
    send_nd_sol(multicast, &ipv6_tentative_address, 135);

    lease6.status = 4; // address duplication check

    wait_delay(2);

    if(lease6.status == 4)
      break;
  }

  _fmemcpy(taddr, &ipv6_tentative_address, sizeof(struct ipv6_addr));

//  lease6.status = 1;

  if(retries == 0xFF)
  {
//    puts("WARNING: All IPv6 addresses were duplicate, giving up!");
    return 1;
  }

  return 0;
}

static int send_router_sol(void)
{
  return send_nd_sol(&ipv6_all_routers, &ipv6_all_routers, 133);
}

static int send_dhcp6_request(void)
{
  struct udp_data data;
  struct udp4_header header;
  unsigned char dhcp_packet[50];
  struct ipv6_addr dest_addr;
  unsigned char *ptr;
  int retries;
  unsigned long time;
//  unsigned ol;

//  memset(&dest_addr, 0, sizeof(dest_addr));

  if(!ipv6_local_addr.p1)
  {
    lease6.use_dhcp6 = 0;

    ipv6_tentative_address.p1 = 0x80fe;
    get_stateless_ipv6_address(&ipv6_local_addr, 64);

    lease6.status = 6;
    _fmemset(gateway6_mac, -1, 6);
    for(retries=5;retries--;)
    {
      send_router_sol();
      time = ttime(0);
      while(ttime(0) < time+2)
      {
        service_packets();
        if(_fmemcmp(gateway6_mac, broadcast_mac, 6))
          goto router1;
      }
    }
    router1:;
  }

  if(lease6.use_dhcp6)
  {
    lease6.status = 1;
    get_dhcp_server_multicast(&dest_addr);

    header.src_port = 546;
    header.dst_port = 547;

    data.data = dhcp_packet;

    memset(dhcp_packet, 0, sizeof(dhcp_packet));

    *(unsigned long*)&dhcp_packet[0] = lease6.transaction_id;
    lease6_update_elapsed_time();

    dhcp_packet[0] = 1; // message type = solicit

    ptr = &dhcp_packet[4];

    ptr = dhcp6_add_client_identifier(ptr);

    ptr[1] = 6; // option request
    ptr[3] = 2; // length
    ptr[5] = 23; // DNS recursive name server
    ptr+=6;

    ptr = dhcp6_add_elapsed_time(ptr);

    ptr[1] = 3; // option: want ipv6 addresses...
    ptr[3] = 12; // length
    *(unsigned long*)&ptr[4] = lease6.iaid;

    *(unsigned *)&ptr[10] = 0x0020; // preferred renew time?
    *(unsigned *)&ptr[14] = 0x0038; // preferred lifetime?
    ptr += 16;
  
    data.len = ptr - dhcp_packet;

    return send_udp6(dest_addr, &header, &data);
  }
  else if(ipv6_global_prefix_len)
  {
    _fmemcpy(&ipv6_tentative_address, &ipv6_global_prefix, 16);
    lease6.status = get_stateless_ipv6_address(&ipv6_global_addr, ipv6_global_prefix_len);
    
  }
  return 0;
}

inline int resend_dhcp6req(void)
{
  return send_dhcp6_request();
}
