#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

char installdir[80] = "C:\\LEETOS";

char *filelist[][2] = 
{
  { "TCP.EXE", "" },
  { "IPSTAT.EXE", "" },
  { "DRIVERS\\TCPIP.EXE", "" },
  { "LOADMOD\\TCPIP.APP", "STARTUP\\TCPIP.APP" },
  { "TCPSERV.APP", "STARTUP\\TCPSERV.APP" },
  { "IRC.APP", "" },
  { "TELNET.APP", "" }
};

int copy_files(void)
{
  FILE *src;
  FILE *dst;
  unsigned n;
  char dstfile[80];
  int c;
  unsigned char buff[512];

  for(n=0;n<sizeof(filelist)/sizeof(filelist[0]);n++)
  {
    src = fopen(filelist[n][0], "rb");
    if(!src)
    {
      printf("Could not open file %s!\n", filelist[n][0]);
      goto error;
    }
    if(filelist[n][1][0])
      sprintf(dstfile, "%s%s", installdir, filelist[n][1]);
    else
      sprintf(dstfile, "%s%s", installdir, filelist[n][0]);
    dst = fopen(dstfile, "wb");
    if(!dst)
    {
      printf("Could not open file %s!\n", dstfile);
      goto error;
    }
    printf("Source file: %s, ", filelist[n][0]);
    printf("target file: %s\n", dstfile);
    while(c = fread(buff, 1, sizeof(buff), src))
      if(fwrite(buff, c, 1, dst) != 1)
        goto error;
    if(fclose(src) || fclose(dst))
    {
      error:
      printf("Error: %s\n", strerror(errno));
      return 1;
    }
  }
  puts("Done.");
  return 0;
}

int write_config(FILE *fp, char *line)
{
  printf(line);
  return (fwrite(line, strlen(line), 1, fp) != 1);
}

int make_config(void)
{
  char configfile[] = "SETUP.NET";
  char *dhcplines[] =
  {
    "BROADCAST 255.255.255.255\n",
    "DHCP\n"
  };
  char option_mymac[80] = "MAC-MY ";
  char option_gatewaymac[80] = "MAC-GATEWAY ";
  char option_ipaddr[80] = "IPADDR ";
  char option_gateway[80] = "GATEWAY ";
  char option_broadcast[80] = "BROADCAST ";
  char option_netmask[80] = "NETMASK ";
  char option_nameserver[80] = "NAMESERVER ";
  int c;
  unsigned n;
  FILE *fp;
  char configline[80];
  char inputline[80];
  char generating_config[] = "Generating config:";

  sprintf(configline, "%s%s", installdir, configfile);
  fp = fopen(configline, "wt");
  if(!fp)
  {
    puts("Cannot create config file!");
    return 1;
  }
  puts("Do you want to configure the IP address automatically via DHCP? [Y/n]");
  c = getchar();
  if(c != '\n') getchar();
  if((c & 0x1F) == ('y' & 0x1F) || c == '\n')
  {
    puts(generating_config);
    for(n=0;n<sizeof(dhcplines)/sizeof(dhcplines[0]);n++)
    {
      if(write_config(fp, dhcplines[n]))
        return 1;
    }
  }
  else
  {
    printf("IP address of this computer: ");
    fgets(&option_ipaddr[strlen(option_ipaddr)], 40, stdin);
    printf("Gateway IP address: ");
    fgets(&option_gateway[strlen(option_gateway)], 40, stdin);
    printf("Broadcast IP address: ");
    fgets(&option_broadcast[strlen(option_broadcast)], 40, stdin);
    printf("Netmask: ");
    fgets(&option_netmask[strlen(option_netmask)], 40, stdin);
    printf("Nameserver: ");
    fgets(&option_nameserver[strlen(option_nameserver)], 40, stdin);

    puts(generating_config);
    if(write_config(fp, option_ipaddr))
      return 1;
    if(write_config(fp, option_gateway))
      return 1;
    if(write_config(fp, option_broadcast))
      return 1;
    if(write_config(fp, option_netmask))
      return 1;
    if(write_config(fp, option_nameserver))
      return 1;
  }
  puts("\nEnter local MAC address, or press enter for automatic detection.");
  puts("Automatic detection does not work for some packet drivers.");
  fgets(inputline, sizeof(inputline), stdin);
  if(inputline[0] != '\n')
  {
    sprintf(configline, "%s%s", option_mymac, inputline);
    if(write_config(fp, configline))
      return 1;
  }
  if(fclose(fp))
  {
    printf("Error: %s\n", strerror(errno));
    return 1;
  }
  return 0;
}

int update_autoexec(void)
{
  char *buff;
  FILE *fp;
  unsigned l;
  unsigned long ll;
  char autoexecfile[] = "C:\\AUTOEXEC.BAT";
  char newline[] = "\nTCP";
  char nextline[] = "\nMAIN.EXE\n";
  char *ptr;

  fp = fopen(autoexecfile, "rt");
  if(!fp)
  {
    error:
    puts("Cannot update your AUTOEXEC.BAT.");
    return 0;
  }
  fseek(fp, 0, SEEK_END) + sizeof(newline) + 1;
  l = ll = ftell(fp);
  rewind(fp);

  if(l != ll || (!(buff = malloc(l))))
  {
    puts("Out of memory. Your AUTOEXEC.BAT is too long.");
    goto error;
  }
  l = fread(buff, 1, l, fp);
  if(ferror(fp))
    goto error;
  buff[l] = 0;
  fclose(fp);
  
  puts("Your old AUTOEXEC.BAT:");
  puts(buff);

  ptr = strstr(buff, nextline);
  if(!ptr)
  {
    puts("Line \"MAIN.EXE\" was not found in your AUTOEXEC.BAT file. \
Cannot update your AUTOEXEC.BAT automatically. You must run \
TCP before starting the graphical shell.");
    return 0;
  }
  memmove(ptr+strlen(newline), ptr, strlen(ptr)+1);
  memcpy(ptr, newline, strlen(newline));
  puts("Your new AUTOEXEC.BAT:");
  puts(buff);

  puts("Press [ENTER] to update AUTOEXEC.BAT automatically. Press any other \
key to quit.");
  if(getchar() != '\n')
    return 0;

  puts("Writing new AUTOEXEC.BAT...");
  fp = fopen(autoexecfile, "wt");
  if(!fp)
  {
    puts("Could not create new AUTOEXEC.BAT.");
    goto error;
  }
  if(fwrite(buff, strlen(buff), 1, fp) != 1)
    printf("Error: %s\n", strerror(errno));

  if(fclose(fp))
    printf("Error: %s\n", strerror(errno));

  return 0;
}

int main()
{
  char newdir[80];

  puts("lEEt/OS networking tools install program v. 1.1");
  puts("Press CTRL+BREAK to exit this program.");
  printf("Enter lEEt/OS install dir (default: %s): ", installdir);

  fgets(newdir, 80, stdin);

  if(newdir[0] != '\n')
  {
    strcpy(installdir, newdir);
    installdir[strlen(installdir)-1] = 0;
  }

  if(installdir[strlen(installdir)-1] != '\\')
    strcat(installdir, "\\");

  printf("Installing to directory %s\n", installdir);

  if(copy_files() || make_config() || update_autoexec())
  {
    puts("TCP/IP stack is NOT installed.");
    return 1;
  }

  puts("TCP/IP stack is now installed.");
  puts("Reminder: Make sure that a packet driver is loaded to interrupt 0x60.");

  return 0;
}
