#include <stdlib.h>
#include <stdio.h>
//#include <sys/socket.h>
//#include <netinet/in.h>
#include <string.h>
#include <sys/types.h>

#include <socket.h>

struct sockaddr_in sockstrct;


int connect_to_addr(char *addr, unsigned port)
{
  int retval = socket(AF_INET, SOCK_DGRAM, 0);
  uint32_t ip_addr_32;
  unsigned char *ip_addr = (void*)&sockstrct.sin_addr.s_addr;

  if(retval != -1)
  {
    sscanf(addr, "%u.%u.%u.%u", ip_addr, ip_addr+1, ip_addr+2, ip_addr+3);
    printf("Connecting to %u.%u.%u.%u port %u\n", *ip_addr, ip_addr[1], ip_addr[2], ip_addr[3], port);
    sockstrct.sin_port = (port >> 8) | (port << 8);
    sockstrct.sin_family = AF_INET;

    if(connect(retval, &sockstrct, sizeof(struct sockaddr_in)))
      return -1;
  }

  return retval;
}

void telnet_loop(int socket)
{
  char buff[100];
  int c;

  puts("Connected.");

  while(1)
  {
    memset(buff, 0, sizeof(buff));
    gets(buff);
    buff[strlen(buff)] = 0x0D;
    buff[strlen(buff)] = 0x0A;
    send(socket, buff, strlen(buff), 0);
    memset(buff, 0, sizeof(buff));
    c = recv(socket, buff, sizeof(buff), 0);
    if(c == -1 || c == 0)
      break;
    puts(buff);
  }
}

int main(int argc, char *argv[])
{
  unsigned port;
  int skt;

  if(argc < 3)
  {
    puts("No enough arguments");
    return 1;
  }

  port = atoi(argv[2]);

  skt = connect_to_addr(argv[1], port);

  if(skt == -1)
  {
    puts("Connection failed");
    return 1;
  }

  telnet_loop(skt);

  return 0;
}
