static int is_any_address6(void __far*);


static int send_udp6(struct ipv6_addr dst, struct udp4_header *udp_header, struct udp_data *udp_data)
{
  unsigned total_length;
  struct ipv6_header ipv6_header;
  unsigned char __far *packet;
  unsigned char __far *payload;

  packet = get_free_async_buff();
  payload = &packet[14];

  init_ipv6_packet_header(dst, packet, 0);

  init_ipv6_header_struct(&ipv6_header, 17, dst);

  build_ipv6_header(payload, &ipv6_header);

  udp_header->len = udp_data->len+8;

  total_length = build_udp4_packet(&payload[40], udp_header, udp_data, &dst, 1);

  ipv6_inject_lengthinfo(payload, total_length);

  return send_ip6_packet(packet, total_length+14+40);
}
