static int get_dns_request_by_port(unsigned port)
{
  int n = DNS_CACHE_SIZE;

  while(n--)
    if(dns_cache[n].local_port == port)
      break;

  return n;
}

#define udp4_pseudoheader(s, d, l) ipv4_pseudoheader(s, d, l, 17)
static unsigned udp4_checksum(unsigned char __far *packet, unsigned short __far *pseudoheader, unsigned len, unsigned char pseudoheader_len);

static int sender_mac_changed(unsigned socket, unsigned char *sender_mac, void *src_addr)
{
  unsigned m;
  int a;

  for(m=6;m-- && !sockets[socket]->remote_addr[m];);
  if(m == -1)
    _fmemcpy(sockets[socket]->remote_addr, sender_mac, 6);
  else if(_fmemcmp(sockets[socket]->remote_addr, sender_mac, 6))
  {
    if((!sockets[socket]->ipv6 ? (a = address_in_arp_cache(src_addr, 0))
       : (a = address_in_arp_cache(src_addr, 1))) >= 0)
    {
      if(_fmemcmp(arp_cache[a].mac, sender_mac, 6))
        return 1;
      else
        _fmemcpy(sockets[socket]->remote_addr, sender_mac, 6);        
    }      
    else
      return 1;
  }
  return 0;
}

static void udp4_set_peer(unsigned socket, void *addr, unsigned port)

{
  _fmemcpy(&sockets[socket]->ip_addr, addr, sizeof(union ip_addr));
  sockets[socket]->remote_port = port;
}

static int is_any_address(void __far*);

static void parse_udp4(unsigned char __far *packet, struct udp4_header *header,
                       unsigned packet_len, union ip_addr *src_addr,
                       union ip_addr *dst_addr, unsigned char *sender_mac,
                       unsigned char ipv6)
{
  unsigned i, e;
  unsigned short __far *shortptr = (unsigned short __far*)packet;
  
  header->src_port = switch_endianness_s(shortptr[0]);
  header->dst_port = switch_endianness_s(shortptr[1]);
  header->len = switch_endianness_s(shortptr[2]);

  if(packet_len < header->len) return;

  if(!ipv6)
    if(is_any_address(&src_addr->ipv4_addr)) return;
  else
    if(is_any_address((void __far*)&src_addr->ipv6_addr)) return;

  if(!ipv6 ? 
      (src_addr->ipv4_addr.p1 != 127 &&
       udp4_checksum(packet, udp4_pseudoheader(src_addr->ipv4_addr, dst_addr->ipv4_addr, packet_len), packet_len, 6))
    : (!is_localhost6(&src_addr->ipv6_addr) && 
       udp4_checksum(packet, udp6_pseudoheader(src_addr->ipv6_addr, dst_addr->ipv6_addr, packet_len), packet_len, 20)))
    {
      #ifdef DROP_BAD_CHECKSUM_UDP_PACKETS
        rx_error_count++;
        return;
      #endif
    }

  // if the packet is a response to DNS query
  if(!ipv6 ? 
      (!_fmemcmp(&src_addr->ipv4_addr, &ipv4_dns, sizeof(struct ipv4_addr)) && (i = get_dns_request_by_port(header->dst_port)) != -1
       && !parse_dns_ans(&packet[8], &dns_cache[i], packet_len-8))
    : 0);
  else if((i = (!ipv6 ?
           find_socket_by_ports_and_remote_addr4(header->dst_port, header->src_port, src_addr->ipv4_addr, 1)
         : find_socket_by_ports_and_remote_addr6(header->dst_port, header->src_port, src_addr->ipv6_addr, 1))) == -1)
  {
    if((e = find_open_port_by_port(header->dst_port, 1)) != -1
       && (!open_ports[e]->ipv_matters || (open_ports[e]->ipv6 == ipv6)))
    {
      // if port is open and this seems to be a new connection, create new socket
      if((i = find_free_socket_index()) == -1)
        return;
      if(push_socket_queue(e, sockets[i]->socket_descriptor))
        delete_socket(i, 1);
      else
      {
        sockets[i]->local_port = header->dst_port;
        sockets[i]->status = sockets[i]->udp = 1;
        sockets[i]->ipv6 = ipv6;
        udp4_set_peer(i, src_addr, header->src_port);
        sockets[i]->time = ttime(0);
        goto recv;
      }
      return;                              
    }
    else if(!ipv6 && lease.status)
    {
      if(header->dst_port == 68 && header->src_port == 67)
        parse_dhcp_reply(&packet[8], packet_len-8);
    }
    else if(lease6.status)
    {
      if(header->dst_port == 546)
        parse_dhcp6_reply(&packet[8], packet_len-8, &src_addr->ipv6_addr);
    }
  }

  else
  {
    recv:
    if(sender_mac_changed(i, sender_mac, src_addr))
      return; // sender's physical address changed, drop packet
    if(!ipv6 ?
        is_any_address(&sockets[i]->ip_addr.ipv4_addr)
      : is_any_address6(&sockets[i]->ip_addr.ipv6_addr))
      udp4_set_peer(i, &src_addr->ipv4_addr, header->src_port);
    udp4_recv_socket(i, &packet[8], packet_len-8);
  }
}

static unsigned udp4_checksum(unsigned char __far *packet, unsigned short __far *pseudoheader, unsigned len, unsigned char pseudoheader_len)
{
  register unsigned short checksum = 0;
  register unsigned short addition;
  unsigned hlen;
  unsigned short __far *spacket = (unsigned short __far*)packet;

  if(len & 1)
  {
    len--;
    checksum = packet[len];
  }

  hlen = len>>1;

  while(hlen--)
  {
    addition = spacket[hlen];
    checksum += addition;
    if(checksum < addition)
      if(!++checksum)
        checksum++;
  }

  len = pseudoheader_len;

  while(len--)
  {
    addition = pseudoheader[len];
    checksum += addition;
    if(checksum < addition)
      if(!++checksum)
        checksum++;
  }

//  if(checksum == 0xFFFF)
//    checksum = ~checksum;

  return ~checksum;
}

static void build_udp4_header(unsigned char __far *packet, struct udp4_header *header)
{
  unsigned short __far *shortptr = (unsigned short __far*)packet;

  shortptr[0] = switch_endianness_s(header->src_port);
  shortptr[1] = switch_endianness_s(header->dst_port);
  shortptr[2] = switch_endianness_s(header->len);
  shortptr[3] = 0;
}


static unsigned build_udp4_packet(unsigned char __far *packet, struct udp4_header *header, struct udp_data *udp_data, void *dst_addr, unsigned char ipv6)
{
  unsigned short __far *checksum = (unsigned short __far*)&packet[6];
  unsigned char __far *udp_payload = &packet[8];
  unsigned short len = udp_data->len;

  _fmemcpy(udp_payload, udp_data->data, len);

 
  build_udp4_header(packet, header);
  if(!ipv6)
    *checksum = udp4_checksum(packet, udp4_pseudoheader(ipv4_my_addr, *(struct ipv4_addr*)dst_addr, 8+udp_data->len), 8+udp_data->len, 6);
  else
    *checksum = udp4_checksum(packet, udp6_pseudoheader(*ipv6_my_addr, *(struct ipv6_addr*)dst_addr, 8+udp_data->len), 8+udp_data->len, 20);

  return 8 + udp_data->len;
}

static int send_udp4(struct ipv4_addr dst, struct udp4_header *udp_header, struct udp_data *udp_data)
{
  unsigned total_length;
  unsigned ipv4_header_length;
  struct ipv4_header ipv4_header;  
  unsigned char __far *packet;
  unsigned char __far *payload;

  packet = get_free_async_buff();
  payload = &packet[14];

  init_ipv4_packet_header(dst, packet, 0);
  
  init_ipv4_header_struct(&ipv4_header, 17, dst);

  ipv4_header_length = build_ipv4_header(payload, &ipv4_header);

  udp_header->len = udp_data->len + 8;

  total_length = ipv4_header_length + build_udp4_packet(&payload[ipv4_header_length], udp_header, udp_data, &dst, 0);

  ipv4_inject_lengthinfo(payload, total_length);
  ipv4_inject_header_checksum(payload, ipv4_header_length);


  return send_ip_packet(packet, total_length+14);
 
}
