.8086

.MODEL small

.code                               

ORG 0x100

start:

jmp main

dosint_active: db 0
last_dosint: db 0

timer_rtn proc far
  test dosint_active, 0xFF
  jnz notcpcall

  push ax

  in al, 0x21
  push ax
  or al, 0x0F ; disable clock, keyboard and serial interrupts
  out 0x21, al

  xor ax, ax
  int 0x61

  pop ax
  out 0x21, al

  pop ax

  notcpcall:

  db 0xEA
  old_timer_rtn: dd 0
timer_rtn endp

tcpint_active: db 0

tcpint_handler proc far
  test cs:tcpint_active, 0xFF
  jnz notcpint

  inc cs:tcpint_active

  pushf
  db 0x9A
  old_tcpint_handler: dd 0

  dec cs:tcpint_active

  notcpint:
  iret
tcpint_handler endp

dosint_handler proc far
  test cs:last_dosint, 0xFF
  jnz no_zero_dosint

  mov cs:dosint_active, 1
  mov cs:last_dosint, 0
  jmp jmp_old_dosint

  no_zero_dosint:
  test ah, ah
  jz save_dosint
  cmp ah, 0x31
  je save_dosint
  cmp ah, 0x4B
  je save_dosint
  cmp ah, 0x4C
  jne inc_dosint

  save_dosint:
  mov cs:last_dosint, ah
  jmp jmp_old_dosint

  inc_dosint:
  inc cs:dosint_active
  
  jmp_old_dosint:
  pushf
  db 0x9A
  old_dosint_handler: dd 0

  pushf
  dec cs:dosint_active
  popf

  sti

  retf 2

dosint_handler endp


main proc near
  mov ax, 0x3561
  int 0x21
  mov word ptr old_tcpint_handler, bx
  mov word ptr old_tcpint_handler+2, es
  mov dx, offset tcpint_handler
  mov ax, 0x2561
  int 0x21

  mov ax, 0x351c
  int 0x21
  mov word ptr old_timer_rtn, bx
  mov word ptr old_timer_rtn+2, es
  mov dx, offset timer_rtn
  mov ax, 0x251c
  int 0x21

  mov ax, 0x3521
  int 0x21
  mov word ptr old_dosint_handler, bx
  mov word ptr old_dosint_handler+2, es
  mov dx, offset dosint_handler
  mov ax, 0x2521
  int 0x21

  mov es, word ptr ds:[0x2c]
  mov ah, 0x49
  int 0x21

  xor bx, bx
  close_file_loop:
  mov ah, 0x3E
  int 0x21
  jc files_closed
  inc bx
  jmp close_file_loop
  files_closed:

  mov ax, 0x3100
  mov dx, (0xF + OFFSET main)
  mov cl, 4
  shr dx, cl
  int 0x21
main endp


END start
