static int parse_nd_sol(unsigned char __far *packet, unsigned packet_len,
                 struct nd_struct *retstruct)
{
  if(packet_len < 8+16) return -1;

  retstruct->target_addr = (void __far*)&packet[8];

  if(lease6.status == 4)
  {
    if(_fmemcmp(retstruct->target_addr, &ipv6_tentative_address, sizeof(struct ipv6_addr)))
      lease6.status = 5;
    return 1;
  }

  if(_fmemcmp(retstruct->target_addr, &ipv6_local_addr, sizeof(struct ipv6_addr))
    && _fmemcmp(retstruct->target_addr, &ipv6_global_addr, sizeof(struct ipv6_addr)))
    return 1;

  if(packet_len >= 32 && *(unsigned __far*)&packet[24] == 0x0101)
    retstruct->target_mac = &packet[26];
  else
    retstruct->target_mac = 0;

  return 0;
}

static void parse_rt_ad(unsigned char __far *src_mac, unsigned char __far *packet, unsigned packet_len)
{
  unsigned n = 16;
  unsigned option_len;
  unsigned char option;

  if(!_fmemcmp(gateway6_mac, broadcast_mac, 6))
    _fmemcpy(gateway6_mac, src_mac, 6);

  if(packet[5] & 0x80) // managed configuration, use DHCP
    lease6.use_dhcp6 = 1;

  while(n < packet_len)
  {
    option_len = packet[n+1] << 3;
    if(!option_len) break;
    if(packet[n] == 3 && lease6.status == 6) // prefix information
    {
      if((packet[n+3] & 0xC0) == 0xC0) // flags on-link and autonomous set
      {
        ipv6_global_prefix_len = packet[n+2];
        lease6.lease_end_time = 
          switch_endianness_l(*(unsigned long __far*)&packet[n+8]);
        _fmemcpy(&ipv6_global_prefix, &packet[n+16], 16);
      }
    }
    n += option_len;
  }
}

static int answer_nd_sol(struct ipv6_addr *dst_addr, struct nd_struct *nd_struct)
{
  unsigned char packet[32];

  memset(packet, 0, sizeof(packet));

  packet[0] = 136; // message type: nd advertise
//  packet[4] = 0x40; // flags: solicited
  packet[4] = 0x40 | 0x20; // flags: solicited, override

  _fmemcpy(&packet[8], nd_struct->target_addr, 16);

  *(unsigned*)&packet[24] = 0x0102;

  _fmemcpy(&packet[26], my_mac, 6);

  return send_icmp6(*dst_addr, packet, sizeof(packet), nd_struct->target_mac);
}

static void parse_nd_ad(unsigned char __far *packet, unsigned packet_len, unsigned char __far *src_mac)
{
  if(packet_len < 8+16) return;

  if(lease6.status == 4)
  {
    if(_fmemcmp(&packet[8], &ipv6_tentative_address, sizeof(struct ipv6_addr)))
      lease6.status = 5;
    return;
  }

  if(!(packet[4] & 0x40)) return;

  add_to_arp_cache4(*(union ip_addr __far*)&packet[8], src_mac, 1);
}

static int send_nd_sol(struct ipv6_addr __far *dst_addr, 
                       struct ipv6_addr __far *sol_addr, unsigned char code)
{
  unsigned char packet[32];
  unsigned char multicast_mac[6];

  memset(packet, 0, sizeof(packet));

  packet[0] = code;
  memcpy(&packet[8], sol_addr, sizeof(struct ipv6_addr));
  *(unsigned*)&packet[24] = 0x0101;
  _fmemcpy(&packet[26], my_mac, 6);

  ipv6_multicast_mac(dst_addr, multicast_mac);

  return send_icmp6(*dst_addr, packet, 32, multicast_mac);
}
