static unsigned is_icmp_echo_request(struct icmp_header header)
{
  if(header.type == 8 && header.code == 0)
    return 1;
  return 0;
}

static void parse_icmp(unsigned char __far *packet, struct icmp_header *header, struct icmp_echo *icmp_data, unsigned packet_len)
{
  header->type = packet[0];
  header->code = packet[1];

  icmp_data->identifier = switch_endianness_s(*(unsigned short __far*)&packet[4]);
  icmp_data->sequence_number = switch_endianness_s(*(unsigned short __far*)&packet[6]);
  icmp_data->data_len = packet_len - 8;
  icmp_data->data = &packet[8]; // not thread safe
}

static unsigned build_icmp_echo_packet(unsigned char __far *packet, struct icmp_echo *data)
{
  unsigned n = data->data_len;
  unsigned checksum = 0;
  unsigned addition;
  unsigned short __far *shortptr = (unsigned short __far*)packet;

  _fmemcpy(&packet[8], data->data, n);

  shortptr[2>>1] = 0;
  shortptr[4>>1] = switch_endianness_s(data->identifier);
  shortptr[6>>1] = switch_endianness_s(data->sequence_number);

//  for(;n<8+data->data_len/2;n++)

  if(n & 1)
    checksum = packet[8+n-1] << 8;
  for(n=(8+data->data_len)>>1;n--;)
  {
//    addition = switch_endianness_s(shortptr[n]);
    addition = shortptr[n];
    checksum += addition;
    if(checksum < addition)
      if(!++checksum)
        checksum++;
  }  

//  shortptr[2>>1] = switch_endianness_s(~checksum);
  shortptr[2>>1] = ~checksum;

  return 8 + data->data_len;
}

static unsigned build_icmp_packet(unsigned char __far *packet, struct icmp_header *headstruct, struct icmp_echo *data_struct)
{
  packet[0] = headstruct->type;
  packet[1] = headstruct->code;

  switch(headstruct->type)
  {
    case 8:
    case 0:     
      return build_icmp_echo_packet(packet, data_struct);
  }
  return 0;
}
