static unsigned dns_record_is_old(unsigned id)
{
  if(ttime(0) > (dns_cache[id].time + dns_cache[id].time_to_live))
    return 1;
  return 0;
}

static int find_dns_request_by_id(unsigned id)
{
  int n = DNS_CACHE_SIZE;

  while(n--)
    if(dns_cache[n].id == id && !dns_record_is_old(n))
      break;
  return n;
}

char __based(__segname("_CODE")) localhost[] = "localhost";
char __based(__segname("_CODE")) localhost_ip[] = "127.0.0.1";

// returns -1 if dns not found in cache
// replaces the dns name with 127.0.0.1 if localhost
static int find_dns_request_by_dns(char *dns)
{
  int n = DNS_CACHE_SIZE;

  if(!_fstrcmp(dns, localhost)) // TODO: unix-type hosts file
  {
    _fstrcpy(dns, localhost_ip);
    return -1;
  }

  while(n--)
    if(!_fstrcmp(dns, dns_cache[n].dns) && !dns_record_is_old(n))
      break;
  return n;
}

/*static void deformat_dnsreq_name(unsigned char __far *name)
{
  unsigned n;
  while(*name)
  {
    n = *name + 1;
    *name = '.';
    name += n;
  }
}*/

static int parse_dns_ans(unsigned char __far *packet, struct dns_query __far *query, unsigned packet_len)
{
  unsigned query_id;
  int in_cache;
  unsigned char __far *answer;
  unsigned answers;
  unsigned short __far *shortptr = (unsigned short __far*)packet;
  unsigned short nameptr;
  unsigned u;
  unsigned char not_answer = 0;
  unsigned answer_length;
  unsigned flags;
  unsigned rcode;
  unsigned pos;

  if(packet_len < 2) return -1; // bad packet

  query_id = switch_endianness_s(*shortptr);

  if((in_cache = find_dns_request_by_id(query_id)) == -1)
    return -2; // no such request in memory

  if(query != &dns_cache[in_cache])
    return -1;

  if(query->answered)
    return -9;

  if(packet_len < query->len) return -1; // bad

  flags = switch_endianness_s(shortptr[1]);

  if(!(flags & 0x8000)) return -1; // not an answer
  query->answered = 1;

  rcode = flags & 0xF;
  if(rcode > 0 && rcode < 6)
  {
    query->noerror = 0;
    return -1; // the nameserver could not complete the request
  }
  answers = switch_endianness_s(shortptr[3]);    

  pos = query->len;
  answer = packet + pos;

  while(answers--)
  {
    shortptr = (unsigned short __far*)answer;    
    // a record should always be at least 16 octets long...
    if(pos + 16 > packet_len) return -1;
    nameptr = switch_endianness_s(*shortptr);
    if((*answer & 0xC0) == 0xC0) // (nameptr & 0x3FFF) == pointer
    {
      // Name is a pointer
      nameptr &= 0x3FFF;
      answer = (unsigned char __far*)++shortptr;
      pos += 12;
    }
    else
    {
      // Name is not a pointer
      nameptr = pos;
      u = _fstrlen(answer) + 1;
      shortptr = (unsigned short __far*)(answer += u);        
      pos += u + 10;
    }
    if(nameptr > packet_len
      || _fstrlen(&packet[nameptr]) >= packet_len - nameptr) return -1;

    if(switch_endianness_s(*shortptr++) != 1) not_answer = 1; // type != A
    else not_answer = 0;
    
    
    if(switch_endianness_s(*shortptr++) != 1) not_answer = 1; // class != IN
    
    if(*shortptr++) // if the more significant word of TTL is non-zero,
    {
      query->time_to_live = -1; // set TTL to the maximum 16-bit value
      shortptr++;
    }
    else // else use the actual value of TTL
      query->time_to_live = switch_endianness_s(*shortptr++);
    
    answer_length = switch_endianness_s(*shortptr);
    answer = (unsigned char __far*)++shortptr;

    
    if(not_answer)
    {
      if(packet_len < answer_length) return -1;
      answer += answer_length;
      pos += answer_length;
    }
    else
    {        
      if(packet_len < 4) return -1;
/*      query->ip_addr.ipv4_addr.p1 = *answer++;
      query->ip_addr.ipv4_addr.p2 = *answer++;
      query->ip_addr.ipv4_addr.p3 = *answer++;
      query->ip_addr.ipv4_addr.p4 = *answer++;*/
      _fmemcpy(&query->ip_addr.ipv4_addr, answer, 4);
      query->ipv6 = 0;
      answer += 4;
      break;
    }
  }
  return 0;
}

static void format_dnsreq_name(unsigned char __far *name)
{
  unsigned char __far *ptr;
  
  while(*name == '.')
  {
    ptr = name + 1;
    if(ptr = _fstrchr(ptr, '.')) 
    {
      *name = ptr - name - 1;
      name = ptr;
    }
    else
    {
      *name = _fstrlen(name+1);
    }
  }
}

static struct ipv4_addr *is_ipv4_address(char *dns)
{
  unsigned n = 4;
  static struct ipv4_addr __based (__segname("_CODE")) retval;
  static char __based(__segname("_CODE")) * __based (__segname("_CODE")) ptr[4] = { &retval.p4, &retval.p3, &retval.p2, &retval.p1 };

  while(n--)
  {
    *ptr[n] = strtouint(dns, &dns);
    if(!!n == (*dns == '.')) dns++;
    else
      return 0;
  }
      
  return &retval;
}

static struct ipv6_addr *is_ipv6_address(char *dns)
{
  static struct ipv6_addr __based (__segname("_CODE")) retval;

  if(strchr(dns, ':'))
  {
    strtoipv6(&retval, dns);
    return &retval;
  }
  return 0;
}

static unsigned send_dns4_req(struct ipv4_addr dst, char *dns)
{
  struct udp4_header udp_header;
  struct udp_data udp_data;
  char data[128];
  unsigned short *shortptr = (unsigned short*)data;
  unsigned char *queries = &data[12];
  unsigned qn = 0;
  char domain[DNS_NAME_LEN+2];
  unsigned dns_table_index = dns_cache_index & (DNS_CACHE_SIZE-1);
  struct dns_query __far *query = &dns_cache[dns_table_index];
  char __far *sdns = query->dns;
  int n;
  void __based(__segname("_CODE")) *ip_addr;

  if(((n = find_dns_request_by_dns(dns)) != -1))
  {
    if(!dns_cache[n].noerror)
      _fmemset(&dns_cache[n], 0, sizeof(struct dns_query));
    return n; // already in cache
  }

  if(ip_addr = is_ipv4_address(dns)) // is already an ip address
  {
    is_ip:
    dns_cache[dns_table_index].answered = 1;
    dns_cache[dns_table_index].noerror = 1;
    _fmemcpy(&dns_cache[dns_table_index].ip_addr, ip_addr, sizeof(union ip_addr));
    _fstrcpy(dns_cache[dns_table_index].dns, dns);
    dns_cache[dns_table_index].time_to_live = -1;

    return dns_cache_index++ & (DNS_CACHE_SIZE-1);        
  }
  else if(ip_addr = is_ipv6_address(dns))
  {
    dns_cache[dns_table_index].ipv6 = 1;
    goto is_ip;
  }

  query->answered = 0;
  query->noerror = 1;

  domain[0] = '.';
  strcpy(&domain[1], dns);
  _fstrcpy(sdns, dns);

  format_dnsreq_name(domain);

  query->id = random();
  shortptr[0] = switch_endianness_s(query->id);  
  query->inverse = 0;
  shortptr[1] = switch_endianness_s(0x0120);  // flags
  shortptr[2] = switch_endianness_s(1);  // questions
  shortptr[3] = switch_endianness_s(0); // answers
  shortptr[4] = switch_endianness_s(0); // authority RRs
  shortptr[5] = switch_endianness_s(0); // additional RRs

  query->nameptr = queries-data;

  _fstrcpy(&queries[qn++], domain);
  qn += strlen(domain);
  shortptr = (unsigned short*)&queries[qn];
  qn = 0;
  shortptr[qn++] = switch_endianness_s(1);
  shortptr[qn++] = switch_endianness_s(1);

  query->len = udp_data.len = (unsigned char*)&shortptr[qn] - data;

  query->local_port = udp_header.src_port = get_free_port(1, &dst, 53, 0);
  udp_header.dst_port = 53;

  udp_data.data = data;

  send_udp4(dst, &udp_header, &udp_data);

  query->time = ttime(0);
  query->time_to_live = DNS_TIMEOUT;

  return dns_cache_index++ & (DNS_CACHE_SIZE-1);
}
