unsigned char __based(__segname("_CODE")) dhcp_magic_cookie[4] =
{
  0x63, 0x82, 0x53, 0x63
};

static void parse_dhcp_options(unsigned char __far *options, unsigned char optlen)
{
  unsigned n = 4;
  unsigned char option;
  unsigned char len;
  unsigned long time;

  if(optlen < 4 || _fmemcmp(options, dhcp_magic_cookie, 4)) return;
 
  do
  {
    option = options[n++];
    if(option == 0xFF) break;
    len = options[n++];
    switch(option)
    {
      case 51: // lease time
      case 58: // renew time
      case 59: // rebind time
        time = ttime(0);
        if(lease.lease_end_time > time + switch_endianness_l(*(unsigned long __far*)&options[n]))
          lease.lease_end_time = time + switch_endianness_l(*(unsigned long __far*)&options[n]);
        break;
      case 1: // subnet mask
        ipv4_netmask = *(struct ipv4_addr __far*)&options[n];
        break;
      case 3: // router
        ipv4_gateway = *(struct ipv4_addr __far*)&options[n];
        break;
      case 6: // dns server
        if(!lease.user_dns)
          ipv4_dns = *(struct ipv4_addr __far*)&options[n];
    }
    n += len;
  }
  while(n < optlen);
}

static int parse_dhcp_reply(unsigned char __far *packet, unsigned len)
{
  if(len < 0xEC) return 1; // too short packet
  if(packet[0] != 2) return 2; // was not BOOTREPLY

  if(*(unsigned long __far*)&packet[4] != lease.id) return 3;
  if(!*(unsigned long __far*)&packet[16]) return 4; // was DHCPNAK
  ipv4_my_addr = *(struct ipv4_addr __far*)&packet[16];

  parse_dhcp_options(&packet[0xEC], len - 0xEC);

  if(lease.status == 1)
  {
    lease.status = 2; // waiting for DHCPACK
    return send_dhcp_request(); // send DHCPREQUEST
  }
  else
  {
    lease.status = 0;
  }

  return 0;
}

unsigned char __based(__segname("_CODE")) parameter_request_list[] = 
{
  0x37, 0x04, 
  0x01, // subnet mask
  0x1C, // broadcast address
  0x06, // domain name server
  0x03 // router
};

static int send_dhcp_request(void)
{
  struct udp_data data;
  struct udp4_header header;
  unsigned char dhcp_packet[300];
  

  header.src_port = 68;
  header.dst_port = 67;
  data.data = dhcp_packet;
  data.len = 300;

  memset(dhcp_packet, 0, sizeof(dhcp_packet));

  dhcp_packet[0] = 1; // BOOTREQUEST
  dhcp_packet[1] = 1; // 10 MBPS ETHERNET
  dhcp_packet[2] = 6; // MAC ADDRESS LENGTH
  dhcp_packet[3] = 0; // hops

  *(unsigned long*)&dhcp_packet[4] = lease.id; // identification 32-bit random number
  *(unsigned *)&dhcp_packet[8] = switch_endianness_s(lease.time_elapsed = ttime(0) - lease.request_time);
  *(struct ipv4_addr *)&dhcp_packet[12] = ipv4_my_addr; // this must be zero at first try
//  *(unsigned long*)dhcp_packet[16] // client's IP address from server
//  *(struct ipv4_addr *)&dhcp_packet[20] // gateway IP address from server
  _fmemcpy(&dhcp_packet[28], my_mac, 6);

  _fmemcpy(&dhcp_packet[0xEC], dhcp_magic_cookie, 4);
//  dhcp_packet[0xEC+4] = 0x35; // request type
//  dhcp_packet[0xEC+5] = 1;
  *(unsigned*)&dhcp_packet[0xEC+4] = 0x0135;
  if(lease.lease_end_time != -1) dhcp_packet[0xEC+6] = 3; // DHCPREQUEST
  else dhcp_packet[0xEC+6] = 1; // DHCPDISCOVER
  _fmemcpy(&dhcp_packet[0xEC+7], parameter_request_list, sizeof(parameter_request_list));
  dhcp_packet[0xEC+7+sizeof(parameter_request_list)] = 0xFF;

  return send_udp4(ipv4_broadcast, &header, &data);
}

inline int resend_dhcpreq(void)
{
  return send_dhcp_request();
}
