// protocols
#define IP_PROTO_RAW 1
#define IP_PROTO_ICMP 1
#define IP_PROTO_TCP3 2

#define IP_PROTO_TCP4 6

#define IP_PROTO_TCP2 10

#define IP_PROTO_UDP 17

// size of incoming raw packet buffer in paragraphs (must be two's exponent)
#define RAW_PACKET_BUFFER 0x80

#define RAW_PACKET_BUFFER_MAX (RAW_PACKET_BUFFER<<4)-1

// maximum number of raw packets in incoming buffer (must be two's exponent)
#define RAW_PACKET_COUNT 0x10

#define MAX_SOCKETS 24
#define MAX_OPEN_PORTS 0x3

// uncomment this to disable high performance packet driver functionality
//#define DISABLE_HIPERF

// maximum number of outgoing packet buffers if high performance
// functionality is enabled
#define MAX_HIPERF_OUTPACKET_BUFFERS 4

// must be 2^x
#define SOCKET_OUT_BUFF_SIZE 0x200
// must be 2^x
#define SOCKET_IN_BUFF_SIZE 0x200

// when a socket's outgoing data buffer has only this much free space left,
// the tcp/ip stack attempts to send data to make more space
#define OUT_BUFF_MIN_FREE_SPACE (SOCKET_OUT_BUFF_SIZE>>4)


// maximum size of outgoing packet
#define OUT_PACKET_SIZE SOCKET_OUT_BUFF_SIZE + 0x80

// number of outgoing packets to send before waiting for ACK
#define OUT_PACKETS 0x10

#define INIT_PLOSS (OUT_PACKETS)

#define DNS_NAME_LEN 128
#define DNS_CACHE_SIZE 0x10 // must be 2^x

// drop incoming UDP packets that have bad checksum
#define DROP_BAD_CHECKSUM_UDP_PACKETS

// timeouts
#define DNS_TIMEOUT 20

#define TCP_TIMEOUT 30

#define DHCP_TIMEOUT 20

#define TCP_RETRANSMISSION_TIME 1

#define CLOSE_TIMEOUT 300

#define ARP_ENTRY_TTL 60

#define SOCKET_QUEUE_LEN 8

// delay to answer retransmitted SYN-ACK packets
// can be commented out to have no delay, but some
// routers can have problems with "too fast" TCP stacks
//#define TCP_RETRANS_ANSWER_DELAY 1

#define MAX_RETRIES 16

// must be 2^x
#define ARP_CACHE_SIZE 0x10

// Promiscuous mode disable - does not usually work with SLIP. Normally
// the network adapter already does this, so it's recommended to keep the TCP
// stack always in promiscuous mode.
//#define NOPROMISCUOUS
